/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.algorithms;

import moea.commons.Entity;
import moea.commons.Population;
import moea.commons.assigner.AssignerNsga2;
import moea.mopso.algorithms.MOPSO;
import moea.mopso.society.Particle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSPSO
extends MOPSO {
    AssignerNsga2<Particle> assigner = new AssignerNsga2();

    public NSPSO(String name, Population<Particle> popIni, int maxT) {
        super(name, popIni, maxT);
    }

    public void assignParameters(Particle p) {
        double c2;
        double c1;
        double w;
        double cd = p.getProperty("crowdingDistance").doubleValue();
        if (cd == Double.MAX_VALUE) {
            w = 1.0 / cd;
            c1 = 0.0;
            c2 = 0.0;
        } else {
            w = (1.0 + cd) / (1.0 + Math.pow(1.0 + cd, 2.0));
            c1 = 1.0 + w;
            c2 = 1.0 + w;
        }
        p.setW(w);
        p.setC1(c1);
        p.setC2(c2);
    }

    @Override
    public void step() {
        Population childPop = new Population();
        for (Particle pTemp : this.pop) {
            childPop.add(pTemp.clone());
        }
        Particle p = null;
        for (int i = 0; i < childPop.size(); ++i) {
            p = (Particle)childPop.get(i);
            this.assignParameters(p);
            p.updatePosition();
            p.updateVelocity();
            p.applyConstraints();
            p.updatePBest();
            p.updateGBest((Particle)this.pop.get((int)(Math.random() * (double)Entity.getN())));
        }
        Population mixedPop = new Population();
        mixedPop.add(this.pop);
        mixedPop.add(childPop);
        this.pop = this.assigner.reduce(mixedPop, this.popSizeMax);
        ++this.t;
    }
}

