/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm;

import Individuals.Individual;
import jeco.dmm.DMMOptimizer;

public class DMMOptimizerAtienza {
    protected DMMOptimizer optimizer;
    protected Individual bestIndividual;
    protected double virtualTime;
    protected float minutesPerDMM;

    public Individual getBestIndividual() {
        return this.bestIndividual;
    }

    public double getVirtualTime() {
        return this.virtualTime;
    }

    public DMMOptimizerAtienza(long sizeOfMemoryInKB, String pathToProfile, String pathToGrammarFile, float minutesPerDMM) {
        this.optimizer = new DMMOptimizer(sizeOfMemoryInKB, pathToProfile, pathToGrammarFile);
        this.optimizer.setProperty("generations", "64");
        this.optimizer.setProperty("population_size", "64");
        this.optimizer.setProperty("max_depth", "10");
        this.minutesPerDMM = minutesPerDMM;
        this.bestIndividual = null;
        this.virtualTime = 0.0;
    }

    public void execute() throws Exception {
        this.virtualTime = 0.0;
        int numIterations = Integer.valueOf(this.optimizer.getProperty("generations"));
        int popSize = Integer.valueOf(this.optimizer.getProperty("population_size"));
        double best = Double.MAX_VALUE;
        for (int currentIteration = 0; currentIteration < numIterations; ++currentIteration) {
            this.optimizer.initialize();
            double temp = this.optimizer.getBestFitness().getDouble();
            if (temp < best) {
                this.bestIndividual = this.optimizer.getBestFitness().getIndividual();
                best = temp;
            }
            this.virtualTime += (double)popSize * ((double)(this.minutesPerDMM * 60.0f + 20.0f) + 30.0 * Math.random());
        }
    }
}

