/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import jeco.dmm.simulator.DMMData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMMRealProfileGenerator {
    protected String profilePath;
    protected int memorySizeInKB;
    protected ArrayList<Integer> sizesInBytes;

    public DMMRealProfileGenerator(String profilePath, int memorySizeInKB, ArrayList<Integer> sizesInBytes) {
        this.profilePath = profilePath;
        this.memorySizeInKB = memorySizeInKB;
        this.sizesInBytes = sizesInBytes;
    }

    public void generateProfile(long numEntries) throws Exception {
        long currentMemAddr = 1L;
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.profilePath)));
        ArrayList<DMMData> objectsCreated = new ArrayList<DMMData>();
        double memorySizeInBytes = Math.pow(2.0, 10.0) * (double)this.memorySizeInKB;
        double currentMemorySize = 0.0;
        long i = 0L;
        while (i < numEntries) {
            long size;
            String line = null;
            int randomIndex = (int)(Math.random() * (double)this.sizesInBytes.size());
            int indexOp = (int)(4.0 * Math.random());
            if (indexOp == 0) {
                size = this.sizesInBytes.get(randomIndex).intValue();
                if (currentMemorySize + (double)size <= memorySizeInBytes) {
                    DMMData dataObject = new DMMData(Long.toBinaryString(currentMemAddr++), size);
                    currentMemorySize += (double)size;
                    objectsCreated.add(dataObject);
                    line = "new " + dataObject.getId() + " " + size + "\n";
                }
            } else if (indexOp == 1) {
                if (objectsCreated.size() > 0) {
                    randomIndex = (int)(Math.random() * (double)objectsCreated.size());
                    String dataId = ((DMMData)objectsCreated.get(randomIndex)).getId();
                    int randomNumAccessInstr = (int)(Math.random() * 30.0) + 1;
                    for (int j = 0; j < randomNumAccessInstr; ++j) {
                        int indexAccOp = (int)(2.0 * Math.random());
                        if (indexAccOp == 0) {
                            if (j == 0) {
                                line = "read " + dataId + "\n";
                                continue;
                            }
                            line = line + "read " + dataId + "\n";
                            continue;
                        }
                        line = j == 0 ? "write " + dataId + "\n" : line + "write " + dataId + "\n";
                    }
                }
            } else if (objectsCreated.size() > 0) {
                randomIndex = (int)(Math.random() * (double)objectsCreated.size());
                DMMData object = (DMMData)objectsCreated.get(randomIndex);
                objectsCreated.remove(randomIndex);
                size = object.getSizeInBytes();
                currentMemorySize -= (double)size;
                line = "delete " + object.getId() + " " + size + "\n";
            }
            if (line == null) continue;
            writer.write(line);
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java -jar DMMRealProfileGenerator.jar <PathToProfileReport> <NumOfEntries> <MemSizeInKB> <size1 size2 ... sizeN>");
            System.out.println("where:");
            System.out.println("<PathToProfileReport>: Is the relative path to the output profiling report.");
            System.out.println("<NumOfEntries>: Is the number of entries desired (# of allocations/deallocations).");
            System.out.println("<MemSizeInKB>: Is the memory size (in KB).");
            System.out.println("<size1 size2 ... sizeN>: Are the different block sizes (in bytes).");
            int i = 0;
            args = new String[14];
            args[i++] = "test" + File.separator + "testReal.profile";
            args[i++] = "3000";
            args[i++] = "2048";
            args[i++] = "12";
            args[i++] = "16";
            args[i++] = "24";
            args[i++] = "36";
            args[i++] = "64";
            args[i++] = "128";
            args[i++] = "256";
            args[i++] = "512";
            args[i++] = "1024";
            args[i++] = "1500";
            args[i++] = "3000";
        }
        String profilePath = args[0];
        long numEntries = Long.valueOf(args[1]);
        int memorySizeInKB = Integer.valueOf(args[2]);
        ArrayList<Integer> sizesInBytes = new ArrayList<Integer>();
        for (int i = 3; i < args.length; ++i) {
            sizesInBytes.add(Integer.valueOf(args[i]));
        }
        DMMRealProfileGenerator generator = new DMMRealProfileGenerator(profilePath, memorySizeInKB, sizesInBytes);
        try {
            generator.generateProfile(numEntries);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

