/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.reliableDMM;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import jeco.dmm.reliableDMM.LRU;
import jeco.dmm.reliableDMM.MemoryBank;
import jeco.dmm.reliableDMM.ReliableDMMData;
import jeco.dmm.simulator.DMMLogger;

public class ReliableDMMCreator {
    protected int numBanks;
    protected String originalProfilePath;
    protected String finalPath;
    protected LRU lruList;
    protected long limit;

    public ReliableDMMCreator(int numBanks, String originalProfilePath, String finalPath, long limit) throws Exception {
        this.numBanks = numBanks;
        this.originalProfilePath = originalProfilePath;
        this.finalPath = finalPath;
        this.lruList = new LRU();
        for (int i = 0; i < numBanks; ++i) {
            MemoryBank memBank = new MemoryBank(i, finalPath);
            this.lruList.insert(memBank);
            DMMLogger.addExecutionTimeReliableSystem(2L);
        }
        this.limit = limit;
        DMMLogger.addMemUsedByReliableSystem(3 * numBanks);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws Exception {
        long lineNumber = 0L;
        String[] parts = null;
        String operation = null;
        String dataId = null;
        int consecutiveAccesses = 0;
        int maxConsecutiveAccesses = 0;
        int activeBank = 0;
        int numExceed = 0;
        BufferedReader reader = new BufferedReader(new FileReader(new File(this.originalProfilePath)));
        ArrayList<ReliableDMMData> activeObjects = new ArrayList<ReliableDMMData>();
        String line = reader.readLine();
        while (line != null) {
            int bankId;
            ++lineNumber;
            parts = line.split(" ");
            operation = parts[0];
            dataId = parts[1];
            if (operation.equals("new")) {
                MemoryBank memBank = this.lruList.getLRUBank();
                ReliableDMMData data = new ReliableDMMData(memBank, dataId);
                activeObjects.add(data);
                memBank.writeFile(line);
                int bankId2 = memBank.getNumOfBank();
                if (bankId2 != activeBank) {
                    memBank.addAccess(consecutiveAccesses);
                    consecutiveAccesses = 1;
                    activeBank = bankId2;
                } else {
                    ++consecutiveAccesses;
                }
                DMMLogger.addExecutionTimeReliableSystem(2L);
                DMMLogger.addMemoryAccessedByReliableSystem(1L);
            } else if (operation.equals("delete")) {
                boolean found = false;
                ReliableDMMData data = null;
                for (int i = 0; !found && i < activeObjects.size(); ++i) {
                    data = (ReliableDMMData)activeObjects.get(i);
                    if (!data.getId().equals(dataId)) continue;
                    activeObjects.remove(i);
                    this.lruList.update(data.getBank());
                    found = true;
                }
                if (!found) throw new Exception("Unexpected error. Reading Profile for ReliableDMMCreator. Delete");
                data.getBank().writeFile(line);
                bankId = data.getBank().getNumOfBank();
                if (bankId != activeBank) {
                    data.getBank().addAccess(consecutiveAccesses);
                    consecutiveAccesses = 1;
                    activeBank = bankId;
                } else {
                    ++consecutiveAccesses;
                }
                DMMLogger.addExecutionTimeReliableSystem(2L);
                DMMLogger.addMemoryAccessedByReliableSystem(1L);
            } else {
                boolean found = false;
                ReliableDMMData data = null;
                for (int i = 0; !found && i < activeObjects.size(); ++i) {
                    data = (ReliableDMMData)activeObjects.get(i);
                    if (!data.getId().equals(dataId)) continue;
                    this.lruList.update(data.getBank());
                    found = true;
                }
                if (!found) throw new Exception("Unexpected error. Reading Profile for ReliableDMMCreator. Read or write Operation");
                bankId = data.getBank().getNumOfBank();
                if (bankId != activeBank) {
                    data.getBank().addAccess(consecutiveAccesses);
                    consecutiveAccesses = 1;
                    activeBank = bankId;
                } else {
                    ++consecutiveAccesses;
                }
                DMMLogger.addExecutionTimeReliableSystem(2L);
                DMMLogger.addMemoryAccessedByReliableSystem(1L);
            }
            line = reader.readLine();
        }
        reader.close();
        String[] aux = this.originalProfilePath.split("\\.", 2);
        String tempPath = aux[0] + this.numBanks + "BanksReliable.Accesses";
        BufferedWriter writerAccesses = new BufferedWriter(new FileWriter(new File(tempPath)));
        writerAccesses.write("CONCURRENT ACCESSES TO EACH REGION\n");
        for (MemoryBank currentBank = this.lruList.getHead(); currentBank != null; currentBank = currentBank.getNext()) {
            ArrayList<Integer> temp = currentBank.getAccessesList();
            writerAccesses.write("Region " + currentBank.getNumOfBank() + ": ");
            for (int i = 0; i < temp.size(); ++i) {
                int auxInt = temp.get(i);
                if (auxInt > maxConsecutiveAccesses) {
                    maxConsecutiveAccesses = auxInt;
                }
                if ((long)auxInt > this.limit) {
                    ++numExceed;
                }
                writerAccesses.write(auxInt + " ");
            }
            writerAccesses.write("\n");
            currentBank.closeFile();
        }
        writerAccesses.write("\nINFO\n----\n");
        writerAccesses.write("Number of regions exceeding " + this.limit + " accesses (ERRORS): " + numExceed + "\n");
        writerAccesses.write("Max number of consecutive accesses: " + maxConsecutiveAccesses + "\n");
        writerAccesses.flush();
        writerAccesses.close();
    }
}

