/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.reliableDMM;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Properties;
import jeco.dmm.DMMFitness;
import jeco.dmm.DMMGrammarFilter;
import jeco.dmm.DMMOptimizer;
import jeco.dmm.simulator.DMMHeap;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.layers.AbstractHeap;

public class TestReliable {
    protected long sizeOfMemoryInKB;
    protected String pathToProfile;
    protected String pathToOutputGrammar;

    public TestReliable(long sizeOfMemoryInKB, String pathToProfile, String pathToOutputGrammar) throws Exception {
        this.sizeOfMemoryInKB = sizeOfMemoryInKB;
        this.pathToProfile = pathToProfile;
        this.pathToOutputGrammar = pathToOutputGrammar;
        DMMGrammarFilter filter = new DMMGrammarFilter(sizeOfMemoryInKB, pathToProfile, pathToOutputGrammar);
        filter.getInfo();
        filter.createGrammar();
    }

    public double[] explore() throws Exception {
        double[] fitness = new double[5];
        AbstractHeap heap = null;
        Properties properties = new Properties();
        properties.setProperty("profile_path", this.pathToProfile);
        DMMFitness fitFunction = new DMMFitness();
        fitFunction.setProperties(properties);
        double startTime = System.currentTimeMillis();
        DMMOptimizer optimizer = new DMMOptimizer(this.sizeOfMemoryInKB, this.pathToProfile, this.pathToOutputGrammar);
        optimizer.setProperty("generations", "100");
        optimizer.setProperty("population_size", "60");
        optimizer.setProperty("max_depth", "10");
        optimizer.initialize();
        optimizer.execute();
        heap = fitFunction.composeHeap(optimizer.getBestFitness().getIndividual().getPhenotype());
        double endTime = System.currentTimeMillis();
        double totalTime = (endTime - startTime) / 1000.0;
        DMMHeap.reset();
        DMMLogger.reset();
        fitFunction.simulate(heap);
        fitness[0] = DMMLogger.getExecutionTimeReal() + DMMLogger.getMemoryUsedInHeap() + DMMLogger.getMemUsedByDMMSupport() + DMMLogger.getMemoryAccessesReal();
        fitness[1] = DMMLogger.getExecutionTimeReal();
        fitness[2] = DMMLogger.getMemoryUsedInHeap() + DMMLogger.getMemUsedByDMMSupport();
        fitness[3] = DMMLogger.getMemoryAccessesReal();
        fitness[4] = totalTime;
        return fitness;
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            long memory = (long)(128.0 * Math.pow(2.0, 20.0) / Math.pow(2.0, 10.0));
            System.out.println("Memory in KB: " + memory);
            args = new String[]{"EXTENDEDGE", "128", String.valueOf(memory), "test" + File.separator + "physics128Banks.profile", "test" + File.separator + "grammar.bnf"};
            System.out.println("Usage:");
            System.out.println("DMMExplore <KINGSLEY|LEA|ATIENZA#N|GE|ALL> <NumTrials> <SizeOfMemoryInKB> <PathToProfile> <PathToOutputGrammar>");
            System.out.println("Example: DMMExplore KINGSLEY 1 2048 test.profile grammar.bnf");
            System.out.println("where:");
            System.out.println("KINGSLEY: Evaluates the application using the KINGSLEY DMM");
            System.out.println("LEA: Evaluates the application using the DOUG LEA DMM");
            System.out.println("ATIENZA#N: Evaluates the application using David's method, where #N is the number of minutes need to evaluate a DMM in his method");
            System.out.println("GE: Evaluates the application using Grammatical Evolution");
            System.out.println("ALL: Evaluates the application using all the four methods (with 3 minutes for David's method, i.e., ATIENZA3 is used)");
            System.out.println("<NumTrials>: Number of trials (It will save an output file for each trial and method");
            System.out.println("<SizeOfMemoryInKB>: Memory size (in KB)");
            System.out.println("<PathToProfile>: Relative path to the profiling report");
            System.out.println("<PathToOutputGrammar>: Relative path to the output grammar");
        }
        String method = args[0];
        int numTrials = Integer.valueOf(args[1]);
        long sizeOfMemoryInKB = Long.valueOf(args[2]);
        String pathToProfile = args[3];
        String pathToOutputGrammar = args[4];
        try {
            int j;
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(pathToProfile + "." + method)));
            float[] totalFitness = new float[5];
            for (int i = 0; i < totalFitness.length; ++i) {
                totalFitness[i] = 0.0f;
            }
            String pathToProfileTemp = "";
            String[] temp = pathToProfile.split("\\.", 2);
            pathToProfileTemp = temp[0] + 0 + "." + temp[1];
            TestReliable explorer = new TestReliable(sizeOfMemoryInKB, pathToProfileTemp, pathToOutputGrammar);
            double[] fitness = explorer.explore();
            for (j = 0; j < fitness.length; ++j) {
                int n = j;
                totalFitness[n] = (float)((double)totalFitness[n] + fitness[j]);
                writer.write("" + fitness[j] + "\t");
            }
            writer.write("\n");
            writer.flush();
            temp = pathToProfile.split("\\.", 2);
            pathToProfileTemp = temp[0] + 1 + "." + temp[1];
            explorer = new TestReliable(sizeOfMemoryInKB, pathToProfileTemp, pathToOutputGrammar);
            fitness = explorer.explore();
            for (j = 0; j < fitness.length; ++j) {
                int n = j;
                totalFitness[n] = (float)((double)totalFitness[n] + fitness[j]);
                writer.write("" + fitness[j] + "\t");
            }
            writer.write("\n");
            writer.flush();
            writer.write("\n\nTOTAL:\n");
            for (j = 0; j < totalFitness.length; ++j) {
                writer.write("" + totalFitness[j] + "\t");
            }
            writer.flush();
            writer.close();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

