/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib.allocator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.allocator.Allocator;
import jeco.dmm.sim2.lib.freelist.Block;
import jeco.dmm.sim2.lib.freelist.BlockComparatorByPosition;
import jeco.dmm.sim2.lib.freelist.FreeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegregatedFreeList
extends Allocator {
    private static Logger logger = Logger.getLogger(SegregatedFreeList.class.getName());

    public SegregatedFreeList(long minSizeInB, long maxSizeInB, boolean allowSplitting, boolean allowCoalescing) {
        super(minSizeInB, maxSizeInB, allowSplitting, allowCoalescing);
    }

    @Override
    public void setup(FreeList.DATA_STRUCTURE dataStructure, FreeList.ALLOCATION_MECHANISM fitAlgorithm, FreeList.ALLOCATION_POLICY policy) {
        logger.info("A " + this.getClass().getName() + " allocator does not need a call to setup, It must be configured externally.");
    }

    @Override
    public Block malloc(long sizeInB, Block hottest) {
        Block newBlock;
        FreeList adm = this.whichFreeListCanManageThisAscending(0, sizeInB);
        Block block = adm.malloc(sizeInB, hottest);
        if (block.getPosition() < 0L && (this.allowSplitting || this.allowCoalescing) && (newBlock = this.tryToCoalesceOrSplit(sizeInB)) != null) {
            block = newBlock;
        }
        return block;
    }

    private Block split(long sizeInB, ArrayList<Block> freeBlocks) {
        this.metrics.incSplittings(1);
        Block currentBlock = null;
        Block newBlock = null;
        long currentBlockNewSizeInB = 0L;
        long newBlockSizeInB = sizeInB;
        FreeList adm = this.whichFreeListCanManageThisAscending(0, sizeInB);
        newBlock = new Block(adm, 0L, newBlockSizeInB);
        for (int i = 0; i < freeBlocks.size(); ++i) {
            currentBlock = freeBlocks.get(i);
            currentBlockNewSizeInB = currentBlock.getSizeInB() - newBlockSizeInB;
            if (currentBlockNewSizeInB <= 0L || (adm = this.whichAdmCanManageThisDescending(currentBlock.getFreeList().getIndex(), currentBlockNewSizeInB)) == null) continue;
            this.metrics.incSuccessSplittings(1);
            currentBlock.getFreeList().removeBlockByPosition(currentBlock.getPosition());
            currentBlock.setFreeList(adm);
            currentBlock.setSizeInB(currentBlockNewSizeInB);
            adm.getFreeBlocks().add(currentBlock);
            newBlock.setPosition(currentBlock.getPosition() + currentBlock.getSizeInB());
            return newBlock;
        }
        return null;
    }

    private Block coalesce(long sizeInB, ArrayList<Block> freeBlocks) {
        this.metrics.incCoalescings(1);
        Block blockI = null;
        Block blockJ = null;
        Block blockIJ = null;
        long finalSizeInB = 0L;
        for (int i = 0; i < freeBlocks.size() - 1; ++i) {
            blockI = freeBlocks.get(i);
            blockJ = freeBlocks.get(i + 1);
            if (blockJ.getPosition() - blockI.getPosition() != blockI.getSizeInB() || (finalSizeInB = blockI.getSizeInB() + blockJ.getSizeInB()) < sizeInB || finalSizeInB > this.maxSizeInB) continue;
            int startIndex = blockI.getFreeList().getIndex() >= blockJ.getFreeList().getIndex() ? blockI.getFreeList().getIndex() : blockJ.getFreeList().getIndex();
            FreeList adm = this.whichFreeListCanManageThisAscending(startIndex, finalSizeInB);
            this.metrics.incSuccessCoalescings(1);
            blockI.getFreeList().removeBlockByPosition(blockI.getPosition());
            blockJ.getFreeList().removeBlockByPosition(blockJ.getPosition());
            blockIJ = new Block(adm, blockI.getPosition(), finalSizeInB);
            return blockIJ;
        }
        return null;
    }

    private FreeList whichFreeListCanManageThisAscending(int startIndex, long sizeInB) {
        FreeList adm = null;
        for (int idx = startIndex; idx < this.freeLists.size(); ++idx) {
            this.metrics.addExecutionTime(1L);
            this.metrics.addMemoryAccesses(1L);
            if (!((FreeList)this.freeLists.get(idx)).canManage(sizeInB)) continue;
            adm = (FreeList)this.freeLists.get(idx);
            break;
        }
        if (adm == null) {
            logger.warning("No free list found for " + sizeInB + "B, [" + this.minSizeInB + ", " + this.maxSizeInB + "]");
        }
        return adm;
    }

    private FreeList whichAdmCanManageThisDescending(int startIndex, long sizeInB) {
        FreeList adm = null;
        for (int idx = startIndex; idx > -1; --idx) {
            this.metrics.addExecutionTime(1L);
            this.metrics.addMemoryAccesses(1L);
            if (!((FreeList)this.freeLists.get(idx)).canManage(sizeInB)) continue;
            adm = (FreeList)this.freeLists.get(idx);
            break;
        }
        return adm;
    }

    private Block tryToCoalesceOrSplit(long sizeInB) {
        Block block = null;
        ArrayList<Block> freeBlocks = this.getAllFreeBlocksSorted();
        if (this.allowSplitting && (block = this.split(sizeInB, freeBlocks)) != null) {
            return block;
        }
        if (this.allowCoalescing && (block = this.coalesce(sizeInB, freeBlocks)) != null) {
            return block;
        }
        return block;
    }

    private ArrayList<Block> getAllFreeBlocksSorted() {
        ArrayList<Block> freeBlocks = new ArrayList<Block>();
        for (FreeList adm : this.freeLists) {
            freeBlocks.addAll(adm.getFreeBlocks());
        }
        Collections.sort(freeBlocks, new BlockComparatorByPosition());
        return freeBlocks;
    }
}

