/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.tools;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.util.ProfilingReport;
import jeco.kernel.util.LoggerFormatter;

public class DmmOptimizer {
    public static final String DMM_KINGSLEY = "KINGSLEY";
    public static final String DMM_LEA = "LEA";
    public static final String DMM_FIBONACCI = "FIBONACCI";
    public static final String DMM_SEGREGATED = "SEGREGATED";
    public static final String DMM_EXACT = "EXACT";
    public static final String DMM_GE = "GE";
    protected String dmmSelected = null;
    protected String profilePath = null;
    protected String mtrPath = null;
    protected String mapPath = null;
    protected ProfilingReport profilingReport = null;
    protected DynamicMemoryManager manager = null;

    public DmmOptimizer(String profilePath, String dmmSelected) {
        this.profilePath = profilePath;
        this.dmmSelected = dmmSelected;
        String baseName = null;
        int pos = profilePath.lastIndexOf(".mem");
        baseName = pos < 0 ? profilePath : profilePath.substring(0, pos);
        baseName = baseName + "." + dmmSelected;
        this.mtrPath = baseName + ".mtr";
        this.mapPath = baseName + ".map";
    }

    public void readProfile() throws InterruptedException {
        this.profilingReport = new ProfilingReport(this.profilePath);
        this.profilingReport.start();
        this.profilingReport.join();
    }

    public void setLevel(Level level) {
        try {
            FileHandler fh = new FileHandler(DmmOptimizer.class.getSimpleName() + ".txt", false);
            Logger.getLogger("").addHandler(fh);
        }
        catch (IOException ex) {
            Logger.getLogger(DmmOptimizer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(DmmOptimizer.class.getName()).log(Level.SEVERE, null, ex);
        }
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(level);
            handlers[index].setFormatter(LoggerFormatter.formatter);
        }
    }

    public void runKingsley() {
    }

    public static void main(String[] args) {
        String profilePath = null;
        String dmmSelected = null;
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equals("-p")) {
                profilePath = args[i + 1];
            }
            if (!args[i].equals("-d")) continue;
            dmmSelected = args[i + 1];
        }
        DmmOptimizer dmmOptimizer = new DmmOptimizer(profilePath, dmmSelected);
        try {
            dmmOptimizer.readProfile();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DmmOptimizer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

