/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.tools;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.Simulator;
import jeco.dmm.sim2.lib.allocator.BuddySystem;
import jeco.dmm.sim2.lib.allocator.ExactSegregatedFit;
import jeco.dmm.sim2.lib.allocator.Kingsley;
import jeco.dmm.sim2.lib.allocator.SegregatedFreeList;
import jeco.dmm.sim2.lib.allocator.SimpleSegregatedStorage;
import jeco.dmm.sim2.lib.freelist.FreeList;
import jeco.dmm.sim2.util.ManagersCreator;
import jeco.dmm.sim2.util.ProfilingReport;
import jeco.gui.util.MyFileFilter;
import jeco.gui.util.TextAreaOutputStream;
import jeco.kernel.util.LoggerFormatter;

public class Test
extends JFrame {
    private static Logger logger = Logger.getLogger(Test.class.getName());
    protected ProfilingReport profilingReport = null;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton loadProfile;
    private JTextArea logArea;
    private JComboBox logLevel;
    private JTextField profPath;
    private JButton runButton;

    public Test() {
        this.initComponents();
        this.logLevel.setSelectedIndex(5);
        PrintStream stream = new PrintStream(new TextAreaOutputStream(this.logArea));
        System.setOut(stream);
        System.setErr(stream);
    }

    private void initComponents() {
        this.profPath = new JTextField();
        this.loadProfile = new JButton();
        this.jLabel1 = new JLabel();
        this.logLevel = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.logArea = new JTextArea();
        this.runButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.loadProfile.setText("Load ...");
        this.loadProfile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Test.this.loadProfileActionPerformed(evt);
            }
        });
        this.jLabel1.setText("LOG LEVEL:");
        this.logLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"ALL", "CONFIG", "FINE", "FINER", "FINEST", "INFO", "OFF", "SEVERE", "WARNING", " "}));
        this.logArea.setColumns(20);
        this.logArea.setFont(new Font("Courier New", 0, 10));
        this.logArea.setRows(5);
        this.jScrollPane1.setViewportView(this.logArea);
        this.runButton.setText("Run ...");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Test.this.runButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 481, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.profPath, -1, 404, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logLevel, -2, -1, -2).addGap(176, 176, 176))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.runButton, -1, -1, Short.MAX_VALUE).addComponent(this.loadProfile, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.profPath, -2, -1, -2).addComponent(this.loadProfile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.logLevel, -2, -1, -2).addComponent(this.runButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 268, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void loadProfileActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(Test.class.getName())) {
            c = c.getParent();
        }
        Test mainWin = (Test)c;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("."));
        MyFileFilter filter = new MyFileFilter();
        filter.addExtension("mem");
        filter.setDescription("MEM File");
        fc.setFileFilter(filter);
        fc.showOpenDialog(mainWin);
        File file = fc.getSelectedFile();
        if (file != null && file.exists()) {
            mainWin.profPath.setText(file.getAbsolutePath());
        }
        if (this.profilingReport != null) {
            this.profilingReport.stopReading();
            try {
                this.profilingReport.join();
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        this.profilingReport = new ProfilingReport(this.profPath.getText());
        this.profilingReport.start();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        long maxSizeInB;
        Level[] level = new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.OFF, Level.SEVERE, Level.WARNING};
        int i = this.logLevel.getSelectedIndex();
        LogManager.getLogManager().getLogger("").setLevel(level[i]);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(level[i]);
            handlers[index].setFormatter(LoggerFormatter.formatter);
        }
        if (this.profilingReport.isAlive()) {
            logger.warning("The profiling report is still being loaded.");
            return;
        }
        logger.info("Min size: " + this.profilingReport.getMinSizeInB() + "B");
        logger.info("Max size: " + this.profilingReport.getMaxSizeInB() + "B");
        ArrayList<DynamicMemoryManager> dmms = new ArrayList<DynamicMemoryManager>();
        logger.info("Creating a SimpleSegregatedStorage Allocator...");
        long minSizeInB = (long)(this.profilingReport.computeSizeUsageAvg() - this.profilingReport.computeSizeUsageStd());
        if (minSizeInB < 0L) {
            minSizeInB = 0L;
        }
        if ((maxSizeInB = (long)(this.profilingReport.computeSizeUsageAvg() + this.profilingReport.computeSizeUsageStd())) > this.profilingReport.getMaxSizeInB()) {
            maxSizeInB = this.profilingReport.getMaxSizeInB();
        }
        SimpleSegregatedStorage simpleSegregatedStorage = new SimpleSegregatedStorage(minSizeInB, maxSizeInB);
        simpleSegregatedStorage.setup(FreeList.DATA_STRUCTURE.SLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
        dmms.add(new DynamicMemoryManager(simpleSegregatedStorage));
        logger.info("Creating a ExactSegregatedFit Allocator...");
        ExactSegregatedFit exactSegregatedFit = new ExactSegregatedFit(0L, this.profilingReport.getMaxSizeInB(), this.profilingReport.getSizesInB());
        exactSegregatedFit.setup(FreeList.DATA_STRUCTURE.SLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
        dmms.add(new DynamicMemoryManager(exactSegregatedFit));
        logger.info("Creating a BuddySystem(Binary) Allocator (no splitting, no coalescing) ...");
        BuddySystem buddySystemBinary1 = new BuddySystem(BuddySystem.TYPE.BINARY, 0L, this.profilingReport.getMaxSizeInB(), false, false);
        buddySystemBinary1.setup(FreeList.DATA_STRUCTURE.SLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
        dmms.add(new DynamicMemoryManager(buddySystemBinary1));
        logger.info("Creating a BuddySystem(Binary) Allocator (splitting, coalescing) ...");
        BuddySystem buddySystemBinary2 = new BuddySystem(BuddySystem.TYPE.BINARY, 0L, this.profilingReport.getMaxSizeInB(), true, true);
        buddySystemBinary2.setup(FreeList.DATA_STRUCTURE.SLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
        dmms.add(new DynamicMemoryManager(buddySystemBinary2));
        logger.info("Creating a BuddySystem(Fibonacci) Allocator (no splitting, no coalescing) ...");
        BuddySystem buddySystemFibonacci1 = new BuddySystem(BuddySystem.TYPE.FIBONACCI, 0L, this.profilingReport.getMaxSizeInB(), false, false);
        buddySystemFibonacci1.setup(FreeList.DATA_STRUCTURE.SLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
        dmms.add(new DynamicMemoryManager(buddySystemFibonacci1));
        logger.info("Creating a BuddySystem(Fibonacci) Allocator (splitting, coalescing) ...");
        BuddySystem buddySystemFibonacci2 = new BuddySystem(BuddySystem.TYPE.FIBONACCI, 0L, this.profilingReport.getMaxSizeInB(), true, true);
        buddySystemFibonacci2.setup(FreeList.DATA_STRUCTURE.SLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
        dmms.add(new DynamicMemoryManager(buddySystemFibonacci2));
        logger.info("Creating 10 Free Lists in a Segregated Fit allocator (no splitting, no coalescing)...");
        SegregatedFreeList segregatedFreeList1 = new SegregatedFreeList(0L, this.profilingReport.getMaxSizeInB(), false, false);
        ManagersCreator.buildSeveralFreeLists(10, segregatedFreeList1, FreeList.DATA_STRUCTURE.BTREE, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
        dmms.add(new DynamicMemoryManager(segregatedFreeList1));
        logger.info("Creating 10 Free Lists in a Segregated Fit allocator (splitting, coalescing)...");
        SegregatedFreeList segregatedFreeList2 = new SegregatedFreeList(0L, this.profilingReport.getMaxSizeInB(), true, true);
        ManagersCreator.buildSeveralFreeLists(10, segregatedFreeList2, FreeList.DATA_STRUCTURE.BTREE, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
        dmms.add(new DynamicMemoryManager(segregatedFreeList2));
        logger.info("Creating Kingsley ...");
        DynamicMemoryManager dmmKingsley = new DynamicMemoryManager(new Kingsley());
        dmms.add(dmmKingsley);
        logger.info("done.");
        for (DynamicMemoryManager dmm : dmms) {
            try {
                Simulator simulator = new Simulator(this.profilingReport, dmm);
                simulator.start();
                simulator.join();
                logger.info(simulator.drawAllocatorMap());
                logger.info(simulator.getMetrics().report());
            }
            catch (InterruptedException ex) {
                logger.severe(ex.getLocalizedMessage());
                break;
            }
        }
        logger.info("DONE.");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Test test = new Test();
                test.setTitle("DMM Simulator test");
                test.setVisible(true);
            }
        });
    }
}

