/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingReport
extends Thread {
    private static Logger logger = Logger.getLogger(ProfilingReport.class.getName());
    public static final String MALLOC = "malloc";
    public static final String FREE = "free";
    public static final String READ = "read";
    public static final String WRITE = "write";
    protected String pathToProfile;
    protected long size = 0L;
    protected long sizeErrors = 0L;
    protected long objectIdErrors = 0L;
    protected long mallocs = 0L;
    protected long totalMemory = 0L;
    protected long maxMemoryInUse = 0L;
    protected long frees = 0L;
    protected long freeIdErrors = 0L;
    protected long mallocsAfterFrees = 0L;
    protected long reads = 0L;
    protected long writes = 0L;
    protected long minSizeInB;
    protected long maxSizeInB;
    protected TreeSet<Long> sizesInB;
    protected TreeMap<Long, Long> sizeUsage = new TreeMap();
    protected boolean stopped;

    public String getPathToProfile() {
        return this.pathToProfile;
    }

    public long getSize() {
        return this.size;
    }

    public long getMinSizeInB() {
        return this.minSizeInB;
    }

    public long getMaxSizeInB() {
        return this.maxSizeInB;
    }

    public TreeSet<Long> getSizesInB() {
        return this.sizesInB;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public ProfilingReport(String pathToProfile) {
        this.pathToProfile = pathToProfile;
        this.size = 0L;
        this.minSizeInB = Long.MAX_VALUE;
        this.maxSizeInB = Long.MIN_VALUE;
        this.sizesInB = new TreeSet();
        this.stopped = true;
    }

    public void load() throws FileNotFoundException, IOException {
        logger.info("Loading " + this.pathToProfile + " profiling report ...");
        this.stopped = false;
        this.size = 0L;
        this.minSizeInB = Long.MAX_VALUE;
        this.maxSizeInB = Long.MIN_VALUE;
        this.sizesInB.clear();
        BufferedReader reader = new BufferedReader(new FileReader(new File(this.pathToProfile)));
        HashMap<Long, Long> objectsAlive = new HashMap<Long, Long>();
        String opcode = null;
        double time = 0.0;
        long objectId = 0L;
        Long dataSizeInB = 0L;
        long memoryInUse = 0L;
        Long count = null;
        String lastOp = "";
        String line = null;
        while ((line = reader.readLine()) != null && !this.stopped) {
            ++this.size;
            if ((double)this.size % 1000000.0 == 0.0) {
                logger.info(this.size + " lines processed ...");
            }
            String[] parts = line.split(" ");
            if (line.charAt(0) >= '0' && line.charAt(0) <= '9') {
                time = Double.valueOf(parts[0]);
                opcode = parts[1];
                objectId = Long.valueOf(parts[2]);
                dataSizeInB = Long.valueOf(parts[parts.length - 1]);
                if (opcode.equals("new")) {
                    opcode = MALLOC;
                } else if (opcode.equals("delete")) {
                    opcode = FREE;
                }
            } else {
                opcode = parts[0];
                time = Double.valueOf(parts[1]);
                dataSizeInB = Long.valueOf(parts[2]);
                objectId = Long.valueOf(parts[parts.length - 1]);
            }
            if (objectId < 0L) {
                ++this.objectIdErrors;
                continue;
            }
            if (opcode.equals(MALLOC)) {
                if (dataSizeInB <= 0L) {
                    ++this.sizeErrors;
                    continue;
                }
                this.totalMemory += dataSizeInB.longValue();
                if (this.maxMemoryInUse < (memoryInUse += dataSizeInB.longValue())) {
                    this.maxMemoryInUse = memoryInUse;
                }
                ++this.mallocs;
                objectsAlive.put(objectId, dataSizeInB);
                if (lastOp.equals(FREE)) {
                    ++this.mallocsAfterFrees;
                }
                if (dataSizeInB < this.minSizeInB) {
                    this.minSizeInB = dataSizeInB;
                }
                if (dataSizeInB > this.maxSizeInB) {
                    this.maxSizeInB = dataSizeInB;
                }
                this.sizesInB.add(dataSizeInB);
                count = this.sizeUsage.get(dataSizeInB);
                if (count == null) {
                    count = 1L;
                } else {
                    Long l = count;
                    Long l2 = count = Long.valueOf(count + 1L);
                }
                this.sizeUsage.put(dataSizeInB, count);
            } else if (opcode.equals(FREE)) {
                dataSizeInB = (Long)objectsAlive.remove(objectId);
                if (dataSizeInB != null) {
                    ++this.frees;
                    memoryInUse -= dataSizeInB.longValue();
                } else {
                    ++this.freeIdErrors;
                }
            } else if (opcode.equals(READ)) {
                ++this.reads;
            } else if (opcode.equals(WRITE)) {
                ++this.writes;
            } else {
                logger.severe("Operation not allowed: " + line);
            }
            lastOp = opcode;
        }
        this.stopped = true;
        StringBuffer buffer = new StringBuffer();
        buffer.append("done.\n");
        buffer.append("\tEntries\tValid memory ops\tSizeErrors\tObjectIdError\tMallocs\tFrees\tFreeIdErrors\tMallocsAfterFrees\tReads\tWrites\tTotal memory\tMax in use\tAverage size\tMemory ops/s\n");
        buffer.append(this.pathToProfile);
        buffer.append("\t");
        buffer.append(this.size);
        buffer.append("\t");
        buffer.append(this.mallocs + this.reads + this.writes + this.frees);
        buffer.append("\t");
        buffer.append(this.sizeErrors);
        buffer.append("\t");
        buffer.append(this.objectIdErrors);
        buffer.append("\t");
        buffer.append(this.mallocs);
        buffer.append("\t");
        buffer.append(this.frees);
        buffer.append("\t");
        buffer.append(this.freeIdErrors);
        buffer.append("\t");
        buffer.append(this.mallocsAfterFrees);
        buffer.append("\t");
        buffer.append(this.reads);
        buffer.append("\t");
        buffer.append(this.writes);
        buffer.append("\t");
        buffer.append(this.totalMemory);
        buffer.append("\t");
        buffer.append(this.maxMemoryInUse);
        buffer.append("\t");
        buffer.append(this.computeSizeUsageAvg());
        buffer.append("\t");
        buffer.append((double)this.size / time);
        buffer.append("\n\nSizes:");
        count = 0L;
        double avg1 = 0.0;
        double avg2 = 0.0;
        Iterator<Long> itr = this.sizeUsage.keySet().iterator();
        while (itr.hasNext()) {
            Long l = count;
            Long l3 = count = Long.valueOf(count + 1L);
            Long key = itr.next();
            avg1 += (double)key.longValue();
            Long value = this.sizeUsage.get(key);
            avg2 += (double)value.longValue();
            buffer.append("\t" + key + "\t" + value + "\n");
        }
        buffer.append("Avg:\t" + avg1 / (double)count.longValue() + "\t" + avg2 / (double)count.longValue() + "\n");
        logger.info(buffer.toString());
    }

    @Override
    public void run() {
        try {
            this.load();
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public void stopReading() {
        if (this.isAlive()) {
            this.stopped = true;
        }
    }

    public double computeSizeUsageAvg() {
        long num = 0L;
        double avg = 0.0;
        for (Long blockSize : this.sizeUsage.keySet()) {
            num += this.sizeUsage.get(blockSize).longValue();
            avg += (double)(blockSize * this.sizeUsage.get(blockSize));
        }
        return avg / (double)num;
    }

    public double computeSizeUsageStd() {
        double std = 0.0;
        long num = 0L;
        double avg = this.computeSizeUsageAvg();
        for (Long blockSize : this.sizeUsage.keySet()) {
            num += this.sizeUsage.get(blockSize).longValue();
            std += (double)this.sizeUsage.get(blockSize).longValue() * Math.pow((double)blockSize.longValue() - avg, 2.0);
        }
        return Math.sqrt(std / (double)num);
    }
}

