/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.combining;

import java.lang.reflect.Constructor;
import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.DMMSizesArray;
import jeco.dmm.simulator.headers.LeaHeader;
import jeco.dmm.simulator.headers.SizeHeader;
import jeco.dmm.simulator.layers.AbstractHeap;

public class SegHeap2
extends AbstractHeap {
    protected long maxObjectSize;
    protected AbstractHeap[] myLittleHeap;
    protected int numBins;
    protected AbstractHeap littleHeap;
    protected AbstractHeap bigHeap;
    protected long[] sizesArray;

    public SegHeap2(DMMSizesArray szArray, AbstractHeap littleHeap, AbstractHeap bigHeap) {
        super(bigHeap.getHeader());
        this.sizesArray = szArray.getSizes();
        this.numBins = this.sizesArray.length;
        this.maxObjectSize = this.sizesArray[this.sizesArray.length - 1];
        this.littleHeap = littleHeap;
        this.bigHeap = bigHeap;
        this.myLittleHeap = new AbstractHeap[this.numBins];
        DMMLogger.updateData(7L, 17L, 2 * this.numBins + 4, 6L);
        DMMLogger.addMemUsedByDMMSupport(8 + this.numBins + 4 + 1 + 1 + 8 * this.numBins);
        try {
            int k;
            int j;
            Class<?> objectClass = this.littleHeap.getClass();
            Constructor<?>[] constructors = objectClass.getConstructors();
            for (j = 0; j < constructors.length && constructors[j].getParameterTypes().length != 1; ++j) {
            }
            Class<?> headerClass = this.header.getClass();
            Constructor<?>[] headerConstructors = headerClass.getConstructors();
            for (k = 0; k < headerConstructors.length && headerConstructors[k].getParameterTypes().length != 0; ++k) {
            }
            Object[] parametersAsArray = new Object[1];
            DMMLogger.updateData(this.numBins * 6 + 2, 19 * this.numBins + 5, 0L, 6 * this.numBins + 1);
            for (int i = 0; i < this.numBins; ++i) {
                Object headerObject = headerConstructors[k].newInstance(new Object[0]);
                if (headerObject instanceof SizeHeader) {
                    DMMLogger.redoDataReal(1L, 2L, ((SizeHeader)headerObject).getMaxSizeInBytes(), 0L);
                } else if (headerObject instanceof LeaHeader) {
                    DMMLogger.redoDataReal(1L, 2L, ((LeaHeader)headerObject).getMaxSizeInBytes(), 0L);
                } else {
                    System.err.println("Error. It must not enter here! See SegHeap2. The header doesn't fit");
                    throw new Exception();
                }
                parametersAsArray[0] = headerObject;
                Object object = constructors[j].newInstance(parametersAsArray);
                this.myLittleHeap[i] = (AbstractHeap)object;
            }
        }
        catch (Exception ee) {
            System.err.println("StrictSegHeap: " + ee.getLocalizedMessage());
            DMMLogger.addInfinity();
        }
    }

    protected long cl2sz(int i) {
        DMMLogger.updateData(1L, 2L, 0L, 1L);
        return this.sizesArray[i];
    }

    protected int sz2cl(long sz) {
        DMMLogger.updateData(2L, 4L, 0L, 1L);
        for (int i = 0; i < this.sizesArray.length; ++i) {
            DMMLogger.updateData(1L, 3L, 0L, 1L);
            if (sz <= this.sizesArray[i]) {
                DMMLogger.updateData(1L, 1L, 0L, 0L);
                return i;
            }
            DMMLogger.updateData(2L, 4L, 0L, 1L);
        }
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return -1;
    }

    public DMMBlock free(DMMData dataObject) {
        DMMLogger.updateData(2L, 5L, 0L, 1L);
        long sz = dataObject.getSizeInBytes();
        if (sz > this.maxObjectSize) {
            DMMLogger.updateData(1L, 3L, 0L, 1L);
            return this.bigHeap.free(dataObject);
        }
        DMMLogger.updateData(2L, 7L, 0L, 2L);
        int objectSizeClass = this.sz2cl(sz);
        return this.myLittleHeap[objectSizeClass].free(dataObject);
    }

    public DMMBlock malloc(DMMData dataObject) {
        DMMLogger.updateData(8L, 16L, 0L, 1L);
        DMMBlock ptr = null;
        long sz = dataObject.getSizeInBytes();
        if (sz > this.maxObjectSize) {
            DMMLogger.updateData(2L, 6L, 0L, 1L);
            DMMBlock block = this.bigHeap.malloc(dataObject);
            return block;
        }
        int sc = this.sz2cl(sz);
        if (sc < 0 || sc >= this.numBins) {
            System.err.println("SegHeap::Error in the function sc");
            return null;
        }
        while (ptr == null && sc < this.numBins) {
            DMMLogger.updateData(3L, 9L, 0L, 2L);
            ptr = this.myLittleHeap[sc].malloc(dataObject);
            ++sc;
        }
        if (ptr == null) {
            DMMLogger.updateData(1L, 4L, 0L, 1L);
            ptr = this.bigHeap.malloc(dataObject);
        }
        return ptr;
    }

    public boolean remove(DMMData dataObject) {
        DMMLogger.updateData(2L, 5L, 0L, 1L);
        long objectSize = dataObject.getSizeInBytes();
        if (objectSize > this.maxObjectSize) {
            DMMLogger.updateData(1L, 0L, 0L, 0L);
            return false;
        }
        DMMLogger.updateData(3L, 9L, 0L, 2L);
        int objectSizeClass = this.sz2cl(objectSize);
        boolean ret_val = this.myLittleHeap[objectSizeClass].remove(dataObject);
        return ret_val;
    }
}

