/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.selectors;

import java.util.logging.Logger;
import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMHeap;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.layers.AbstractHeap;
import jeco.dmm.simulator.layers.freelists.AbstractFreeList;
import jeco.dmm.simulator.selectors.AbstractSelector;

public class LtSelector
extends AbstractSelector {
    private static Logger logger = Logger.getLogger(LtSelector.class.getName());
    protected long sizeInBytes;

    public LtSelector(long sizeInBytes) {
        DMMLogger.updateData(1L, 3L, 1L, 0L);
        this.sizeInBytes = sizeInBytes;
    }

    public boolean getMalloc(AbstractHeap heap, DMMData dataObject) {
        DMMLogger.updateData(1L, 3L, 0L, 1L);
        if (dataObject.getSizeInBytes() < this.sizeInBytes) {
            if (heap instanceof AbstractFreeList) {
                AbstractFreeList list = (AbstractFreeList)heap;
                logger.fine("Block sizes (" + this.sizeInBytes + "):" + list.blockSizesToString());
            }
            DMMLogger.updateData(1L, 0L, 0L, 0L);
            return true;
        }
        DMMLogger.updateData(1L, 0L, 0L, 0L);
        return false;
    }

    public boolean getFree(AbstractHeap heap, DMMData dataObject) {
        DMMLogger.updateData(1L, 4L, 0L, 2L);
        DMMBlock block = DMMHeap.findBlock(dataObject.getId());
        if (block.getDataObject().getSizeInBytes() < this.sizeInBytes) {
            if (heap instanceof AbstractFreeList) {
                AbstractFreeList list = (AbstractFreeList)heap;
                logger.fine("Block sizes (" + this.sizeInBytes + "):" + list.blockSizesToString());
            }
            DMMLogger.updateData(1L, 0L, 0L, 0L);
            return true;
        }
        DMMLogger.updateData(1L, 0L, 0L, 0L);
        return false;
    }
}

