/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.test;

import java.io.File;
import jeco.dmm.DMMGrammarFilter;
import jeco.dmm.DMMOptimizer;
import jeco.gui.util.Scope;

public class DMMJoseleTest {
    protected long memorySizeInKB;
    protected String pathToProfile;
    protected String pathToOutputGrammar;

    public DMMJoseleTest(long memorySizeInKB, String pathToProfile, String pathToOutputGrammar) throws Exception {
        this.memorySizeInKB = memorySizeInKB;
        this.pathToProfile = pathToProfile;
        this.pathToOutputGrammar = pathToOutputGrammar;
        DMMGrammarFilter filter = new DMMGrammarFilter(memorySizeInKB, pathToProfile, pathToOutputGrammar);
        filter.getInfo();
        filter.createGrammar();
    }

    public void run() throws Exception {
        DMMOptimizer optimizer = new DMMOptimizer(this.memorySizeInKB, this.pathToProfile, this.pathToOutputGrammar);
        optimizer.setProperty("generations", "30");
        optimizer.initialize();
        optimizer.execute();
        System.out.println("Best fitness: " + optimizer.getBestFitness().getDouble());
    }

    public void runStepLoop() throws Exception {
        DMMOptimizer optimizer = new DMMOptimizer(this.memorySizeInKB, this.pathToProfile, this.pathToOutputGrammar);
        optimizer.initialize();
        long i = 0L;
        Scope scope = new Scope();
        double best = optimizer.getBestFitness().getDouble();
        scope.add(i, best);
        while (true) {
            optimizer.step();
            best = optimizer.getBestFitness().getDouble();
            scope.add(++i, best);
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            args = new String[]{"16384", "test" + File.separator + "test.profile", "test" + File.separator + "grammar.bnf"};
        }
        try {
            DMMJoseleTest test = new DMMJoseleTest(Long.valueOf(args[0]), args[1], args[2]);
            test.runStepLoop();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
        }
    }
}

