/*
 * Decompiled with CFR 0.152.
 */
package jeco.gui.epsilon;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jeco.gui.util.TextAreaOutputStream;
import jeco.kernel.qualityIndicators.UnaryEpsilon;

public class EpsilonWindow
extends JFrame {
    protected String currentPath;
    private JButton addButton;
    private JList addList;
    private JComboBox comboBox;
    private JButton downButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton newButton;
    private JTextField newTextField;
    private JCheckBox normalizeCheckBox;
    private JButton openButton;
    private JTextField openTextField;
    private JButton removeButton;
    private JButton runButton;
    private JTextArea textArea;
    private JButton upButton;

    public EpsilonWindow() {
        this.initComponents();
        this.addList.setModel(new DefaultListModel());
        super.setTitle("Unary Epsilon Indicator");
        this.currentPath = ".";
        PrintStream out = new PrintStream(new TextAreaOutputStream(this.textArea));
        System.setOut(out);
        System.setErr(out);
    }

    private void initComponents() {
        this.openButton = new JButton();
        this.openTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.addList = new JList();
        this.jLabel2 = new JLabel();
        this.addButton = new JButton();
        this.jLabel3 = new JLabel();
        this.newTextField = new JTextField();
        this.newButton = new JButton();
        this.runButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.normalizeCheckBox = new JCheckBox();
        this.jScrollPane2 = new JScrollPane();
        this.textArea = new JTextArea();
        this.comboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.openButton.setText("Open ...");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EpsilonWindow.this.openButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Reference Front");
        this.addList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.addList);
        this.jLabel2.setText("Approximation sets");
        this.addButton.setText("Add...");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EpsilonWindow.this.addButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Results");
        this.newButton.setText("New ...");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EpsilonWindow.this.newButtonActionPerformed(evt);
            }
        });
        this.runButton.setText("Run ...");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EpsilonWindow.this.runButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EpsilonWindow.this.removeButtonActionPerformed(evt);
            }
        });
        this.upButton.setText("Up");
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EpsilonWindow.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setText("Down");
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EpsilonWindow.this.downButtonActionPerformed(evt);
            }
        });
        this.normalizeCheckBox.setSelected(true);
        this.normalizeCheckBox.setText("Normalize");
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.jScrollPane2.setViewportView(this.textArea);
        this.comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"ADDITIVE", "MUTLTIPLICATIVE"}));
        this.jLabel4.setText("METHOD:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, 471, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 379, Short.MAX_VALUE).addComponent(this.openTextField, -1, 379, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openButton, -2, 86, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.normalizeCheckBox, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 95, Short.MAX_VALUE).addComponent(this.jLabel4, -2, 56, -2).addGap(18, 18, 18).addComponent(this.comboBox, -2, 113, -2)).addComponent(this.jScrollPane1, -1, 379, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, -1, 86, Short.MAX_VALUE).addComponent(this.upButton, -1, -1, Short.MAX_VALUE).addComponent(this.downButton, -1, -1, Short.MAX_VALUE)))).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -1, 380, Short.MAX_VALUE).addGap(101, 101, 101)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.runButton, -1, 471, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.newTextField, -1, 379, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newButton, -2, 86, -2)).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 471, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openButton).addComponent(this.openTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton)).addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.normalizeCheckBox).addComponent(this.comboBox, -2, -1, -2).addComponent(this.jLabel4)).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newTextField, -2, -1, -2).addComponent(this.newButton)).addGap(18, 18, 18).addComponent(this.runButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 131, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        boolean normalize = this.normalizeCheckBox.isSelected();
        int methodIndex = this.comboBox.getSelectedIndex();
        String referencePath = this.openTextField.getText();
        ArrayList<String> pathToDataFiles = new ArrayList<String>();
        DefaultListModel model = (DefaultListModel)this.addList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String filePath = (String)model.get(i);
            System.out.println("Data file number " + i + ": " + filePath);
            pathToDataFiles.add(filePath);
        }
        UnaryEpsilon indicator = null;
        try {
            indicator = methodIndex == 0 ? new UnaryEpsilon(pathToDataFiles, referencePath, UnaryEpsilon.METHOD.ADDITIVE) : new UnaryEpsilon(pathToDataFiles, referencePath, UnaryEpsilon.METHOD.MULTIPLICATIVE);
            if (normalize) {
                System.out.print("Normalize objective values in the interval [1,2] ... ");
                indicator.normalize();
                System.out.println("done.");
            }
            System.out.print("\nComputing epsilon indicators ... ");
            ArrayList<ArrayList<Double>> epsilonsArray = indicator.calculateIndicatorValues();
            System.out.println("done.");
            System.out.println("\nWriting to file ... ");
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.newTextField.getText())));
            for (int i = 0; i < epsilonsArray.size(); ++i) {
                ArrayList<Double> epsilons = epsilonsArray.get(i);
                for (Double epsilon : epsilons) {
                    writer.write(epsilon + "\n");
                    System.out.println(epsilon);
                }
                writer.write("\n");
                System.out.println("");
            }
            writer.flush();
            writer.close();
            System.out.println("FINISHED.");
        }
        catch (Exception ee) {
            JOptionPane.showMessageDialog(null, ee.getLocalizedMessage(), "Exception", 0);
        }
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        EpsilonWindow mainWin = (EpsilonWindow)c;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(this.currentPath));
        fc.showOpenDialog(mainWin);
        File file = fc.getSelectedFile();
        if (file != null && file.exists()) {
            mainWin.openTextField.setText(file.getAbsolutePath());
            this.currentPath = file.getParent();
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        EpsilonWindow mainWin = (EpsilonWindow)c;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(this.currentPath));
        fc.showSaveDialog(mainWin);
        File file = fc.getSelectedFile();
        if (file != null) {
            mainWin.newTextField.setText(file.getAbsolutePath());
            this.currentPath = file.getParent();
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        EpsilonWindow mainWin = (EpsilonWindow)c;
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        fc.setCurrentDirectory(new File(this.currentPath));
        fc.showOpenDialog(mainWin);
        File[] files = fc.getSelectedFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file == null || !file.exists()) continue;
            DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
            model.add(model.getSize(), file.getAbsolutePath());
            this.currentPath = file.getParent();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        EpsilonWindow mainWin = (EpsilonWindow)c;
        DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
        int index = this.addList.getSelectedIndex();
        if (index >= 0) {
            model.remove(index);
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        EpsilonWindow mainWin = (EpsilonWindow)c;
        DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
        int index = this.addList.getSelectedIndex();
        if (index > 0) {
            int newIndex = index - 1;
            String fileIndex = (String)model.get(index);
            String fileNewIndex = (String)model.get(newIndex);
            model.set(newIndex, fileIndex);
            model.set(index, fileNewIndex);
            mainWin.addList.setSelectedIndex(newIndex);
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        EpsilonWindow mainWin = (EpsilonWindow)c;
        DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
        int index = this.addList.getSelectedIndex();
        if (index < model.getSize() - 1) {
            int newIndex = index + 1;
            String fileIndex = (String)model.get(index);
            String fileNewIndex = (String)model.get(newIndex);
            model.set(newIndex, fileIndex);
            model.set(index, fileNewIndex);
            mainWin.addList.setSelectedIndex(newIndex);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new EpsilonWindow().setVisible(true);
            }
        });
    }
}

