/*
 * Decompiled with CFR 0.152.
 */
package jeco.gui.hypervolume;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jeco.gui.util.TextAreaOutputStream;
import jeco.kernel.qualityIndicators.UnaryHyperVolume;

public class HyperVolumeWindow
extends JFrame {
    protected String currentPath;
    private JButton addButton;
    private JList addList;
    private JButton downButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton newButton;
    private JTextField newTextField;
    private JCheckBox normalizeCheckBox;
    private JButton openButton;
    private JTextField openTextField;
    private JButton removeButton;
    private JButton runButton;
    private JTextArea textArea;
    private JButton upButton;

    public HyperVolumeWindow() {
        this.initComponents();
        this.addList.setModel(new DefaultListModel());
        super.setTitle("Unary Hypervolume Indicator");
        this.currentPath = ".";
        PrintStream out = new PrintStream(new TextAreaOutputStream(this.textArea));
        System.setOut(out);
        System.setErr(out);
    }

    private void initComponents() {
        this.openButton = new JButton();
        this.openTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.addList = new JList();
        this.jLabel2 = new JLabel();
        this.addButton = new JButton();
        this.jLabel3 = new JLabel();
        this.newTextField = new JTextField();
        this.newButton = new JButton();
        this.runButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.normalizeCheckBox = new JCheckBox();
        this.jScrollPane2 = new JScrollPane();
        this.textArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.openButton.setText("Open ...");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperVolumeWindow.this.openButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Reference Front");
        this.addList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.addList);
        this.jLabel2.setText("Approximation sets");
        this.addButton.setText("Add...");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperVolumeWindow.this.addButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Results");
        this.newButton.setText("New ...");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperVolumeWindow.this.newButtonActionPerformed(evt);
            }
        });
        this.runButton.setText("Run ...");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperVolumeWindow.this.runButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperVolumeWindow.this.removeButtonActionPerformed(evt);
            }
        });
        this.upButton.setText("Up");
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperVolumeWindow.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setText("Down");
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperVolumeWindow.this.downButtonActionPerformed(evt);
            }
        });
        this.normalizeCheckBox.setSelected(true);
        this.normalizeCheckBox.setText("Normalize");
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.jScrollPane2.setViewportView(this.textArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, 471, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 379, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, -1, 86, Short.MAX_VALUE).addComponent(this.upButton, -1, -1, Short.MAX_VALUE).addComponent(this.downButton, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 379, Short.MAX_VALUE).addComponent(this.openTextField, -1, 379, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openButton, -2, 86, -2)).addComponent(this.normalizeCheckBox)).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -1, 380, Short.MAX_VALUE).addGap(101, 101, 101)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.runButton, -1, 471, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.newTextField, -1, 379, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newButton, -2, 86, -2)).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 471, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openButton).addComponent(this.openTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton)).addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.normalizeCheckBox).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newTextField, -2, -1, -2).addComponent(this.newButton)).addGap(18, 18, 18).addComponent(this.runButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 131, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        boolean normalize = this.normalizeCheckBox.isSelected();
        String referencePath = this.openTextField.getText();
        ArrayList<String> pathToDataFiles = new ArrayList<String>();
        DefaultListModel model = (DefaultListModel)this.addList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            pathToDataFiles.add((String)model.get(i));
        }
        UnaryHyperVolume indicator = null;
        try {
            indicator = referencePath.length() > 0 ? new UnaryHyperVolume(pathToDataFiles, referencePath) : new UnaryHyperVolume(pathToDataFiles);
            if (normalize) {
                System.out.print("Normalize objective values in the interval [1,2] ... ");
                indicator.normalize();
                System.out.println("done.");
            }
            System.out.print("\nComputing hypervolumes ... ");
            ArrayList<ArrayList<Double>> volumesArray = indicator.calculateHyperVolumes();
            System.out.println("done.");
            System.out.println("\nWriting to file ... ");
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.newTextField.getText())));
            for (int i = 0; i < volumesArray.size(); ++i) {
                ArrayList<Double> volumes = volumesArray.get(i);
                for (Double volume : volumes) {
                    writer.write(volume + "\n");
                    System.out.println(volume);
                }
                writer.write("\n");
                System.out.println("");
            }
            writer.flush();
            writer.close();
            System.out.println("FINISHED.");
        }
        catch (Exception ee) {
            JOptionPane.showMessageDialog(null, ee.getLocalizedMessage(), "Exception", 0);
        }
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        HyperVolumeWindow mainWin = (HyperVolumeWindow)c;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(this.currentPath));
        fc.showOpenDialog(mainWin);
        File file = fc.getSelectedFile();
        if (file != null && file.exists()) {
            mainWin.openTextField.setText(file.getAbsolutePath());
            this.currentPath = file.getParent();
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        HyperVolumeWindow mainWin = (HyperVolumeWindow)c;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(this.currentPath));
        fc.showSaveDialog(mainWin);
        File file = fc.getSelectedFile();
        if (file != null) {
            mainWin.newTextField.setText(file.getAbsolutePath());
            this.currentPath = file.getParent();
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        HyperVolumeWindow mainWin = (HyperVolumeWindow)c;
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        fc.setCurrentDirectory(new File(this.currentPath));
        fc.showOpenDialog(mainWin);
        File[] files = fc.getSelectedFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file == null || !file.exists()) continue;
            DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
            model.add(model.getSize(), file.getAbsolutePath());
            this.currentPath = file.getParent();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        HyperVolumeWindow mainWin = (HyperVolumeWindow)c;
        DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
        int index = this.addList.getSelectedIndex();
        if (index >= 0) {
            model.remove(index);
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        HyperVolumeWindow mainWin = (HyperVolumeWindow)c;
        DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
        int index = this.addList.getSelectedIndex();
        if (index > 0) {
            int newIndex = index - 1;
            String fileIndex = (String)model.get(index);
            String fileNewIndex = (String)model.get(newIndex);
            model.set(newIndex, fileIndex);
            model.set(index, fileNewIndex);
            mainWin.addList.setSelectedIndex(newIndex);
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(this.getClass().getCanonicalName())) {
            c = c.getParent();
        }
        HyperVolumeWindow mainWin = (HyperVolumeWindow)c;
        DefaultListModel model = (DefaultListModel)mainWin.addList.getModel();
        int index = this.addList.getSelectedIndex();
        if (index < model.getSize() - 1) {
            int newIndex = index + 1;
            String fileIndex = (String)model.get(index);
            String fileNewIndex = (String)model.get(newIndex);
            model.set(newIndex, fileIndex);
            model.set(index, fileNewIndex);
            mainWin.addList.setSelectedIndex(newIndex);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new HyperVolumeWindow().setVisible(true);
            }
        });
    }
}

