/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.algorithm.moga;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import jeco.kernel.algorithm.Algorithm;
import jeco.kernel.operator.comparator.ArrayDominance;
import jeco.kernel.operator.comparator.PropertyComparator;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.operator.crossover.CrossoverOperator;
import jeco.kernel.operator.mutator.MutationOperator;
import jeco.kernel.operator.selector.SelectionOperator;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.util.Distance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPEA2
extends Algorithm {
    protected int maxGenerations;
    protected int maxPopulationSize;
    protected Comparator<Solution> dominance;
    protected int currentGeneration;
    protected Solutions population;
    protected Solutions archive;
    protected MutationOperator mutationOperator;
    protected CrossoverOperator crossoverOperator;
    protected SelectionOperator selectionOperator;
    protected int K;

    public SPEA2(Problem problem, int maxPopulationSize, int maxGenerations, MutationOperator mutationOperator, CrossoverOperator crossoverOperator, SelectionOperator selectionOperator) {
        super("SPEA2", problem);
        this.maxPopulationSize = maxPopulationSize;
        this.maxGenerations = maxGenerations;
        this.mutationOperator = mutationOperator;
        this.crossoverOperator = crossoverOperator;
        this.selectionOperator = selectionOperator;
    }

    @Override
    public void initialize() {
        this.dominance = new SolutionDominance();
        this.K = (int)Math.sqrt(this.maxPopulationSize + this.maxPopulationSize);
        this.population = new Solutions();
        this.archive = new Solutions();
        this.population = this.problem.newRandomSetOfSolutions(this.maxPopulationSize);
        for (Solution solution : this.population) {
            this.problem.evaluate(solution);
            this.problem.evaluateConstraints(solution);
        }
        this.currentGeneration = 0;
    }

    @Override
    public Solutions execute() {
        while (this.currentGeneration < this.maxGenerations) {
            this.step();
        }
        this.archive.keepParetoNonDominated(this.dominance);
        return this.archive;
    }

    @Override
    public void step() {
        ++this.currentGeneration;
        Solutions union = new Solutions();
        union.addAll(this.population);
        union.addAll(this.archive);
        this.assignFitness(union);
        Solutions unionReduced = this.reduceByFitness(union);
        if (unionReduced.size() < this.maxPopulationSize) {
            this.expand(unionReduced, union, this.maxPopulationSize - unionReduced.size());
        } else if (unionReduced.size() > this.maxPopulationSize) {
            unionReduced = this.reduce(unionReduced, this.maxPopulationSize);
        }
        this.archive = unionReduced;
        if (this.currentGeneration == this.maxGenerations) {
            return;
        }
        Solutions offSpringSolutionSet = new Solutions();
        while (offSpringSolutionSet.size() < this.maxPopulationSize) {
            Solution parent1 = this.selectionOperator.execute(this.archive);
            Solution parent2 = this.selectionOperator.execute(this.archive);
            Solution[] offSpring = this.crossoverOperator.execute(parent1, parent2);
            for (int i = 0; i < 1; ++i) {
                this.mutationOperator.execute(offSpring[i]);
                this.problem.evaluate(offSpring[i]);
                this.problem.evaluateConstraints(offSpring[i]);
                offSpringSolutionSet.add(offSpring[i]);
            }
        }
        this.population = offSpringSolutionSet;
    }

    public void assignFitness(Solutions solutions) {
        int compare;
        int j;
        Solution solI;
        int i;
        int popSize = solutions.size();
        int[] strength = new int[popSize];
        int[] raw = new int[popSize];
        double[] density = new double[popSize];
        for (i = 0; i < popSize; ++i) {
            strength[i] = 0;
            raw[i] = 0;
            density[i] = 0.0;
        }
        for (i = 0; i < popSize; ++i) {
            solI = (Solution)solutions.get(i);
            for (j = 0; j < popSize; ++j) {
                if (i == j || (compare = this.dominance.compare(solI, (Solution)solutions.get(j))) >= 0) continue;
                int n = i;
                strength[n] = strength[n] + 1;
            }
        }
        for (i = 0; i < popSize; ++i) {
            solI = (Solution)solutions.get(i);
            for (j = 0; j < popSize; ++j) {
                if (i == j || (compare = this.dominance.compare(solI, (Solution)solutions.get(j))) != 1 && compare != 2) continue;
                int n = i;
                raw[n] = raw[n] + strength[j];
            }
        }
        for (i = 0; i < popSize; ++i) {
            double sigma = this.computeSigma(i, solutions);
            density[i] = 1.0 / (sigma + 2.0);
            double fitness = (double)raw[i] + density[i];
            ((Solution)solutions.get(i)).setProperty("fitness", fitness);
        }
    }

    private double computeSigma(int i, Solutions solutions) {
        return this.computeSigmas(i, solutions).get(this.K);
    }

    private ArrayList<Double> computeSigmas(int i, Solutions solutions) {
        int popSize = solutions.size();
        ArrayList<Double> distancesToI = new ArrayList<Double>();
        Solution solI = (Solution)solutions.get(i);
        for (int j = 0; j < popSize; ++j) {
            double distance = Distance.euclideanDistance(solI, (Solution)solutions.get(j));
            distancesToI.add(distance);
        }
        Collections.sort(distancesToI);
        return distancesToI;
    }

    public Solutions reduceByFitness(Solutions pop) {
        Solutions result = new Solutions();
        for (int i = 0; i < pop.size(); ++i) {
            Solution indI = (Solution)pop.get(i);
            if (!(indI.getProperty("fitness").doubleValue() < 1.0)) continue;
            result.add(indI);
        }
        return result;
    }

    public void expand(Solutions pop, Solutions all, int nElems) {
        int i = 0;
        int count = 0;
        int allSize = all.size();
        Collections.sort(all, new PropertyComparator("fitness"));
        for (i = 0; i < allSize; ++i) {
            Solution indI = (Solution)all.get(i);
            if (!(indI.getProperty("fitness").doubleValue() >= 1.0)) continue;
            pop.add(indI);
            if (++count == nElems) break;
        }
    }

    public Solutions reduce(Solutions pop, int maxSize) {
        int i;
        ArrayList<ArrayList<Double>> allSigmas = new ArrayList<ArrayList<Double>>();
        HashSet<Integer> erased = new HashSet<Integer>();
        int toErase = pop.size() - maxSize;
        ArrayDominance comparator = new ArrayDominance();
        for (i = 0; i < pop.size(); ++i) {
            allSigmas.add(this.computeSigmas(i, pop));
        }
        while (erased.size() < toErase) {
            int min = 0;
            while (erased.contains(min)) {
                ++min;
            }
            for (i = 0; i < pop.size(); ++i) {
                if (i == min || erased.contains(i) || comparator.compare((ArrayList)allSigmas.get(i), (ArrayList)allSigmas.get(min)) != -1) continue;
                min = i;
            }
            erased.add(min);
        }
        Solutions result = new Solutions();
        for (i = 0; i < pop.size(); ++i) {
            if (erased.contains(i)) continue;
            result.add(pop.get(i));
        }
        return result;
    }

    public void setMutationOperator(MutationOperator mutationOperator) {
        this.mutationOperator = mutationOperator;
    }

    public void setCrossoverOperator(CrossoverOperator crossoverOperator) {
        this.crossoverOperator = crossoverOperator;
    }

    public void setSelectionOperator(SelectionOperator selectionOperator) {
        this.selectionOperator = selectionOperator;
    }

    public void setMaxGenerations(int maxGenerations) {
        this.maxGenerations = maxGenerations;
    }

    public void setMaxPopulationSize(int maxPopulationSize) {
        this.maxPopulationSize = maxPopulationSize;
    }
}

