/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.algorithm.mopso;

import java.util.Collections;
import java.util.logging.Logger;
import jeco.kernel.algorithm.Algorithm;
import jeco.kernel.operator.assigner.CrowdingDistance;
import jeco.kernel.operator.assigner.NicheCount;
import jeco.kernel.operator.comparator.PropertyComparator;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.VariableReal;
import jeco.kernel.util.RandomGenerator;

public class NSPSO
extends Algorithm {
    private static Logger logger = Logger.getLogger(NSPSO.class.getName());
    private double c1;
    private double c2;
    protected double chi;
    private int maxT;
    private int swarmSize;
    private String sortingMethod;
    private double topPartPercentage;
    private double w;
    private int t;
    private Solutions swarm;
    private Solutions externalArchive;
    private SolutionDominance dominance;
    private Solution[] personalBests;
    private double[][] speeds;

    public NSPSO(Problem problem, int numParticles, int maxIterations, double w, double c1, double c2, double chi, double topPartPercentage, String sortingMethod) {
        super("NSPSO", problem);
        this.swarmSize = numParticles;
        this.maxT = maxIterations;
        this.w = w;
        this.c1 = c1;
        this.c2 = c2;
        this.chi = chi;
        this.topPartPercentage = topPartPercentage;
        this.sortingMethod = sortingMethod;
    }

    public NSPSO(Problem problem, int numParticles, int maxIterations, double w, double c1, double c2, double chi) {
        this(problem, numParticles, maxIterations, w, c1, c2, chi, 0.25, "CROWDING_DISTANCE");
    }

    public NSPSO(Problem problem, int numParticles, int maxIterations, double w, double c1, double c2) {
        this(problem, numParticles, maxIterations, w, c1, c2, 1.0, 0.25, "CROWDING_DISTANCE");
    }

    public void initialize() {
        this.swarm = this.problem.newRandomSetOfSolutions(this.swarmSize);
        this.externalArchive = new Solutions();
        this.dominance = new SolutionDominance();
        for (Solution particle : this.swarm) {
            this.problem.evaluate(particle);
            this.problem.evaluateConstraints(particle);
            this.externalArchive.add(particle.clone());
        }
        this.reduceExternalArchive(2 * this.swarmSize);
        this.speeds = new double[this.swarmSize][this.problem.getNumberOfVariables()];
        this.personalBests = new Solution[this.swarmSize];
        for (int i = 0; i < this.swarmSize; ++i) {
            Solution particle;
            particle = (Solution)this.swarm.get(i);
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                VariableReal variable = (VariableReal)particle.getVariable(j);
                double value = RandomGenerator.nextDouble((Double)variable.getLowerBound(), (Double)variable.getUpperBound());
                this.speeds[i][j] = RandomGenerator.nextDouble() < 0.5 ? -value : value;
            }
            this.personalBests[i] = particle.clone();
        }
        this.t = 0;
    }

    public Solutions execute() {
        while (this.t < this.maxT) {
            this.step();
        }
        return this.externalArchive;
    }

    public void step() {
        Solution particle;
        int i;
        ++this.t;
        this.computeSpeed();
        this.computeNewPositions();
        for (i = 0; i < this.swarmSize; ++i) {
            particle = (Solution)this.swarm.get(i);
            this.problem.evaluate(particle);
            this.problem.evaluateConstraints(particle);
        }
        for (i = 0; i < this.swarmSize; ++i) {
            particle = (Solution)this.swarm.get(i);
            int flag = this.dominance.compare(particle, this.personalBests[i]);
            if (flag >= 0) continue;
            this.personalBests[i] = particle.clone();
        }
        for (i = 0; i < this.swarmSize; ++i) {
            particle = (Solution)this.swarm.get(i);
            this.externalArchive.add(particle.clone());
        }
        for (i = 0; i < this.swarmSize; ++i) {
            this.externalArchive.add(this.personalBests[i]);
        }
        this.reduceExternalArchive(2 * this.swarmSize);
    }

    private void computeSpeed() {
        Object assigner;
        if (this.externalArchive.size() <= 0) {
            System.out.println("External archive is zero.");
            Solution particle = new Solution(this.problem);
            this.problem.evaluate(particle);
            this.problem.evaluateConstraints(particle);
            this.externalArchive.add(particle);
        }
        if (this.sortingMethod.indexOf("CROWDING_DISTANCE") == 0) {
            assigner = new CrowdingDistance(this.problem.getNumberOfObjectives());
            ((CrowdingDistance)assigner).execute(this.externalArchive);
            Collections.sort(this.externalArchive, new PropertyComparator("crowdingDistance"));
        } else if (this.sortingMethod.indexOf("NICHE_COUNT") == 0) {
            assigner = new NicheCount(this.problem.getNumberOfObjectives());
            ((NicheCount)assigner).execute(this.externalArchive);
            Collections.sort(this.externalArchive, new PropertyComparator("nicheCount"));
        } else {
            logger.severe("Sorting method not propertly defined: " + this.sortingMethod);
        }
        for (int i = 0; i < this.swarmSize; ++i) {
            Solution particle = (Solution)this.swarm.get(i);
            Solution personalBest = this.personalBests[i];
            int randomIndex = (int)((double)this.externalArchive.size() * this.topPartPercentage * RandomGenerator.nextDouble());
            if (this.sortingMethod.indexOf("CROWDING_DISTANCE") == 0) {
                randomIndex = this.externalArchive.size() - 1 - randomIndex;
            }
            Solution globalBest = (Solution)this.externalArchive.get(randomIndex);
            double r1 = RandomGenerator.nextDouble();
            double r2 = RandomGenerator.nextDouble();
            double C1 = RandomGenerator.nextDouble(Math.min(1.5, this.c1), Math.max(1.5, this.c1));
            double C2 = RandomGenerator.nextDouble(Math.min(1.5, this.c2), Math.max(1.5, this.c2));
            double W = RandomGenerator.nextDouble(Math.min(0.1, this.w), Math.max(0.1, this.w));
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                VariableReal vPart = (VariableReal)particle.getVariable(j);
                VariableReal pBest = (VariableReal)personalBest.getVariable(j);
                VariableReal gBest = (VariableReal)globalBest.getVariable(j);
                this.speeds[i][j] = W * this.speeds[i][j] + C1 * r1 * ((Double)pBest.getValue() - (Double)vPart.getValue()) + C2 * r2 * ((Double)gBest.getValue() - (Double)vPart.getValue());
            }
        }
    }

    private void computeNewPositions() {
        for (int i = 0; i < this.swarmSize; ++i) {
            Solution particle = (Solution)this.swarm.get(i);
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                VariableReal variable = (VariableReal)particle.getVariable(j);
                variable.setValue((Double)variable.getValue() + this.chi * this.speeds[i][j]);
                if ((Double)variable.getValue() < (Double)variable.getLowerBound()) {
                    variable.setValue(variable.getLowerBound());
                    this.speeds[i][j] = this.speeds[i][j] * -1.0;
                }
                if (!((Double)variable.getValue() > (Double)variable.getUpperBound())) continue;
                variable.setValue(variable.getUpperBound());
                this.speeds[i][j] = this.speeds[i][j] * -1.0;
            }
        }
    }

    public void reduceExternalArchive(int maxSize) {
        Object assigner;
        this.externalArchive.keepParetoNonDominated(this.dominance);
        if (this.externalArchive.size() <= maxSize) {
            return;
        }
        if (this.sortingMethod.indexOf("CROWDING_DISTANCE") == 0) {
            assigner = new CrowdingDistance(this.problem.getNumberOfObjectives());
            ((CrowdingDistance)assigner).execute(this.externalArchive);
            Collections.sort(this.externalArchive, new PropertyComparator("crowdingDistance"));
        } else if (this.sortingMethod.indexOf("NICHE_COUNT") == 0) {
            assigner = new NicheCount(this.problem.getNumberOfObjectives());
            ((NicheCount)assigner).execute(this.externalArchive);
            Collections.sort(this.externalArchive, new PropertyComparator("nicheCount"));
        } else {
            logger.severe("Sorting method not propertly defined: " + this.sortingMethod);
        }
        while (this.externalArchive.size() > maxSize) {
            if (this.sortingMethod.indexOf("CROWDING_DISTANCE") == 0) {
                this.externalArchive.remove(0);
                continue;
            }
            this.externalArchive.remove(this.externalArchive.size() - 1);
        }
        if (this.sortingMethod.indexOf("_REPLACE") > 0) {
            Solution pI = new Solution(this.problem);
            this.problem.evaluate(pI);
            this.problem.evaluateConstraints(pI);
            if (this.sortingMethod.indexOf("CROWDING_DISTANCE") == 0) {
                this.externalArchive.set(0, pI);
            } else {
                this.externalArchive.set(this.externalArchive.size() - 1, pI);
            }
        }
    }

    public void setMaxT(int maxT) {
        this.maxT = maxT;
    }

    public void setSwarmSize(int swarmSize) {
        this.swarmSize = swarmSize;
    }
}

