/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.algorithm.mopso;

import java.util.Collections;
import java.util.Comparator;
import jeco.kernel.algorithm.Algorithm;
import jeco.kernel.operator.assigner.CrowdingDistance;
import jeco.kernel.operator.comparator.PropertyComparator;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.operator.mutator.NonUniformMutation;
import jeco.kernel.operator.mutator.UniformMutation;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.VariableReal;
import jeco.kernel.util.RandomGenerator;

public class OMOPSO
extends Algorithm {
    private int swarmSize;
    private int maxT;
    private int t;
    private double perturbationIndex;
    private Solutions swarm;
    private Solution[] personalBests;
    private Solutions leaders;
    private double[][] speeds;
    private SolutionDominance objectivesComparator;
    private Comparator<Solution> crowdingDistanceComparator;
    private CrowdingDistance crowdingDistanceAssigner;
    private UniformMutation uniformMutation;
    private NonUniformMutation nonUniformMutation;

    public OMOPSO(Problem problem, int populationSize, int maxT, double perturbationIndex) {
        super("OMOPSO", problem);
        this.swarmSize = populationSize;
        this.maxT = maxT;
        this.perturbationIndex = perturbationIndex;
    }

    public void initialize() {
        this.swarm = this.problem.newRandomSetOfSolutions(this.swarmSize);
        this.personalBests = new Solution[this.swarmSize];
        this.leaders = new Solutions();
        this.objectivesComparator = new SolutionDominance();
        this.crowdingDistanceComparator = new PropertyComparator("crowdingDistance");
        this.crowdingDistanceAssigner = new CrowdingDistance(this.problem.getNumberOfObjectives());
        this.speeds = new double[this.swarmSize][this.problem.getNumberOfVariables()];
        this.uniformMutation = new UniformMutation(1.0 / (double)this.problem.getNumberOfVariables(), this.perturbationIndex);
        this.nonUniformMutation = new NonUniformMutation(1.0 / (double)this.problem.getNumberOfVariables(), this.perturbationIndex, 0, this.maxT);
        this.t = 0;
        for (Solution particle : this.swarm) {
            this.problem.evaluate(particle);
            this.problem.evaluateConstraints(particle);
        }
        for (int i = 0; i < this.swarmSize; ++i) {
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                this.speeds[i][j] = 0.0;
            }
        }
        for (Solution particle : this.swarm) {
            this.leaders.add(particle.clone());
        }
        this.reduceLeaders();
        for (int i = 0; i < this.swarm.size(); ++i) {
            this.personalBests[i] = ((Solution)this.swarm.get(i)).clone();
        }
    }

    public void reduceLeaders() {
        this.leaders.keepParetoNonDominated(this.objectivesComparator);
        if (this.leaders.size() <= this.swarmSize) {
            return;
        }
        this.crowdingDistanceAssigner.execute(this.leaders);
        Collections.sort(this.leaders, this.crowdingDistanceComparator);
        while (this.leaders.size() > this.swarmSize) {
            this.leaders.remove(0);
        }
    }

    private void computeSpeed() {
        this.crowdingDistanceAssigner.execute(this.leaders);
        for (int i = 0; i < this.swarmSize; ++i) {
            Solution particle = (Solution)this.swarm.get(i);
            Solution bestParticle = this.personalBests[i];
            int pos1 = RandomGenerator.nextInt(0, this.leaders.size());
            int pos2 = RandomGenerator.nextInt(0, this.leaders.size());
            Solution one = (Solution)this.leaders.get(pos1);
            Solution two = (Solution)this.leaders.get(pos2);
            Solution bestGlobal = this.crowdingDistanceComparator.compare(two, one) < 1 ? one : two;
            double r1 = RandomGenerator.nextDouble();
            double r2 = RandomGenerator.nextDouble();
            double C1 = RandomGenerator.nextDouble(1.5, 2.0);
            double C2 = RandomGenerator.nextDouble(1.5, 2.0);
            double W = RandomGenerator.nextDouble(0.1, 0.5);
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                VariableReal vPart = (VariableReal)particle.getVariable(j);
                VariableReal pBest = (VariableReal)bestParticle.getVariable(j);
                VariableReal gBest = (VariableReal)bestGlobal.getVariable(j);
                this.speeds[i][j] = W * this.speeds[i][j] + C1 * r1 * ((Double)pBest.getValue() - (Double)vPart.getValue()) + C2 * r2 * ((Double)gBest.getValue() - (Double)vPart.getValue());
            }
        }
    }

    private void computeNewPositions() {
        for (int i = 0; i < this.swarmSize; ++i) {
            Solution particle = (Solution)this.swarm.get(i);
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                VariableReal variable = (VariableReal)particle.getVariable(j);
                variable.setValue((Double)variable.getValue() + this.speeds[i][j]);
                if ((Double)variable.getValue() < (Double)variable.getLowerBound()) {
                    variable.setValue(variable.getLowerBound());
                    this.speeds[i][j] = this.speeds[i][j] * -1.0;
                }
                if (!((Double)variable.getValue() > (Double)variable.getUpperBound())) continue;
                variable.setValue(variable.getUpperBound());
                this.speeds[i][j] = this.speeds[i][j] * -1.0;
            }
        }
    }

    private void mopsoMutation(int currentIteration) {
        this.nonUniformMutation.setCurrentIteration(currentIteration);
        for (int i = 0; i < this.swarm.size(); ++i) {
            if (i % 3 == 0) {
                this.nonUniformMutation.execute((Solution)this.swarm.get(i));
                continue;
            }
            if (i % 3 != 1) continue;
            this.uniformMutation.execute((Solution)this.swarm.get(i));
        }
    }

    public Solutions execute() {
        while (this.t < this.maxT) {
            this.step();
        }
        return this.leaders;
    }

    public void step() {
        int i;
        ++this.t;
        this.computeSpeed();
        this.computeNewPositions();
        this.mopsoMutation(this.t);
        for (i = 0; i < this.swarm.size(); ++i) {
            Solution particle = (Solution)this.swarm.get(i);
            this.problem.evaluate(particle);
            this.problem.evaluateConstraints(particle);
        }
        for (i = 0; i < this.swarm.size(); ++i) {
            Solution particle;
            int flag = this.objectivesComparator.compare((Solution)this.swarm.get(i), this.personalBests[i]);
            if (flag == 1) continue;
            this.personalBests[i] = particle = ((Solution)this.swarm.get(i)).clone();
        }
        for (i = 0; i < this.swarm.size(); ++i) {
            Solution particle = ((Solution)this.swarm.get(i)).clone();
            this.leaders.add(particle);
        }
        this.reduceLeaders();
    }

    public void setSwarmSize(int swarmSize) {
        this.swarmSize = swarmSize;
    }

    public void setMaxT(int maxT) {
        this.maxT = maxT;
    }
}

