/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static Solutions readFrontFromFile(String filePath) throws Exception {
        Solutions solutions = new Solutions();
        BufferedReader reader = new BufferedReader(new FileReader(new File(filePath)));
        String line = reader.readLine();
        while (line != null) {
            String[] objectives = line.split(" ");
            if (line.length() > 0 && objectives != null && objectives.length > 0) {
                Solution solution = new Solution(objectives.length);
                for (int i = 0; i < objectives.length; ++i) {
                    solution.setObjective(i, Double.valueOf(objectives[i]));
                }
                solutions.add(solution);
            }
            line = reader.readLine();
        }
        return solutions;
    }

    public static ArrayList<Solutions> readFrontsFromFile(String filePath) throws Exception {
        ArrayList<Solutions> result = new ArrayList<Solutions>();
        BufferedReader reader = new BufferedReader(new FileReader(new File(filePath)));
        String line = reader.readLine();
        Solutions solutions = new Solutions();
        while (line != null) {
            String[] objectives = line.split(" ");
            if (line.length() <= 0 || objectives == null || objectives.length == 0) {
                if (solutions.size() > 0) {
                    result.add(solutions);
                }
                solutions = new Solutions();
            } else {
                Solution solution = new Solution(objectives.length);
                for (int i = 0; i < objectives.length; ++i) {
                    solution.setObjective(i, Double.valueOf(objectives[i]));
                }
                solutions.add(solution);
            }
            line = reader.readLine();
        }
        return result;
    }

    public static void normalize(ArrayList<Solutions> setOfSolutions, int dim, double lowerBound, double upperBound) {
        double objI;
        int i;
        double[] mins = new double[dim];
        double[] maxs = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            mins[i2] = Double.POSITIVE_INFINITY;
            maxs[i2] = Double.NEGATIVE_INFINITY;
        }
        Solutions allTheSolutions = new Solutions();
        for (Solutions solutions : setOfSolutions) {
            allTheSolutions.addAll(solutions);
        }
        for (Solution solution : allTheSolutions) {
            for (i = 0; i < dim; ++i) {
                objI = solution.getObjective(i);
                if (objI < mins[i]) {
                    mins[i] = objI;
                }
                if (!(objI > maxs[i])) continue;
                maxs[i] = objI;
            }
        }
        for (Solution solution : allTheSolutions) {
            for (i = 0; i < dim; ++i) {
                objI = solution.getObjective(i);
                double newObjI = 1.0 + (objI - mins[i]) / (maxs[i] - mins[i]);
                solution.setObjective(i, newObjI);
            }
        }
    }

    public static void normalize(ArrayList<Solutions> setOfSolutions, int dim) {
        Util.normalize(setOfSolutions, dim, 1.0, 2.0);
    }
}

