/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.papers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.Simulator;
import jeco.dmm.sim2.lib.SimulatorWithReliabilityV1;
import jeco.dmm.sim2.lib.allocator.BuddySystem;
import jeco.dmm.sim2.lib.allocator.ExactSegregatedFit;
import jeco.dmm.sim2.lib.allocator.Kingsley;
import jeco.dmm.sim2.lib.allocator.SegregatedFreeList;
import jeco.dmm.sim2.lib.freelist.FreeList;
import jeco.dmm.sim2.util.ManagersCreator;
import jeco.dmm.sim2.util.ProfilingReport;
import jeco.kernel.util.LoggerFormatter;

public class Vlsi2010 {
    private static Logger logger = Logger.getLogger(Vlsi2010.class.getName());
    public static final String baseDir = "D:/jlrisco/borrar/2010_VLSI";

    public static void main(String[] args) {
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setFormatter(LoggerFormatter.formatter);
        }
        Vlsi2010 dsd2010 = new Vlsi2010();
        try {
            dsd2010.runSimulations();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Vlsi2010.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Vlsi2010.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void runSimulations() throws InterruptedException, IOException {
        int i;
        int i2;
        String[] pathToProfiles = new String[]{baseDir + File.separator + "boxed-sim.mem", baseDir + File.separator + "espresso.mem", baseDir + File.separator + "gcbench.mem"};
        ProfilingReport[] profilingReport = new ProfilingReport[pathToProfiles.length];
        for (i2 = 0; i2 < profilingReport.length; ++i2) {
            profilingReport[i2] = new ProfilingReport(pathToProfiles[i2]);
        }
        for (i2 = 0; i2 < profilingReport.length; ++i2) {
            profilingReport[i2].start();
        }
        for (i2 = 0; i2 < profilingReport.length; ++i2) {
            profilingReport[i2].join();
        }
        DynamicMemoryManager[] managers = new DynamicMemoryManager[8 * profilingReport.length];
        for (int i3 = 0; i3 < profilingReport.length; ++i3) {
            managers[8 * i3 + 0] = new DynamicMemoryManager(new Kingsley());
            BuddySystem fibonacci1 = new BuddySystem(BuddySystem.TYPE.FIBONACCI, 0L, profilingReport[i3].getMaxSizeInB(), false, false);
            fibonacci1.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i3 + 1] = new DynamicMemoryManager(fibonacci1);
            SegregatedFreeList segregated1 = new SegregatedFreeList(0L, profilingReport[i3].getMaxSizeInB(), false, false);
            ManagersCreator.buildSeveralFreeLists(10, segregated1, FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.BEST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i3 + 2] = new DynamicMemoryManager(segregated1);
            ExactSegregatedFit exact1 = new ExactSegregatedFit(0L, profilingReport[i3].getMaxSizeInB(), profilingReport[i3].getSizesInB());
            exact1.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i3 + 3] = new DynamicMemoryManager(exact1);
            managers[8 * i3 + 4] = new DynamicMemoryManager(new Kingsley(FreeList.ALLOCATION_MECHANISM.FARTHEST));
            BuddySystem fibonacci2 = new BuddySystem(BuddySystem.TYPE.FIBONACCI, 0L, profilingReport[i3].getMaxSizeInB(), false, false);
            fibonacci2.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FARTHEST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i3 + 5] = new DynamicMemoryManager(fibonacci2);
            SegregatedFreeList segregated2 = new SegregatedFreeList(0L, profilingReport[i3].getMaxSizeInB(), false, false);
            ManagersCreator.buildSeveralFreeLists(10, segregated2, FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FARTHEST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i3 + 6] = new DynamicMemoryManager(segregated2);
            ExactSegregatedFit exact2 = new ExactSegregatedFit(0L, profilingReport[i3].getMaxSizeInB(), profilingReport[i3].getSizesInB());
            exact2.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FARTHEST, FreeList.ALLOCATION_POLICY.FIFO);
            managers[8 * i3 + 7] = new DynamicMemoryManager(exact2);
        }
        Simulator[] simulators = new Simulator[8 * profilingReport.length];
        for (i = 0; i < profilingReport.length; ++i) {
            simulators[8 * i + 0] = new Simulator(profilingReport[i], managers[8 * i + 0], pathToProfiles[i] + ".Kingsley.acc");
            simulators[8 * i + 1] = new Simulator(profilingReport[i], managers[8 * i + 1], pathToProfiles[i] + ".Fibonacci.acc");
            simulators[8 * i + 2] = new Simulator(profilingReport[i], managers[8 * i + 2], pathToProfiles[i] + ".Segregated10.acc");
            simulators[8 * i + 3] = new Simulator(profilingReport[i], managers[8 * i + 3], pathToProfiles[i] + ".Exact.acc");
            simulators[8 * i + 4] = new SimulatorWithReliabilityV1(profilingReport[i], managers[8 * i + 4], pathToProfiles[i] + ".Kingsley.Farthest.acc");
            simulators[8 * i + 5] = new SimulatorWithReliabilityV1(profilingReport[i], managers[8 * i + 5], pathToProfiles[i] + ".Fibonacci.Farthest.acc");
            simulators[8 * i + 6] = new SimulatorWithReliabilityV1(profilingReport[i], managers[8 * i + 6], pathToProfiles[i] + ".Segregated10.Farthest.acc");
            simulators[8 * i + 7] = new SimulatorWithReliabilityV1(profilingReport[i], managers[8 * i + 7], pathToProfiles[i] + ".Exact.Farthest.acc");
        }
        for (i = 0; i < 8 * profilingReport.length; ++i) {
            simulators[i].start();
        }
        for (i = 0; i < 8 * profilingReport.length; ++i) {
            simulators[i].join();
        }
        for (i = 0; i < profilingReport.length; ++i) {
            this.logAndSaveReports(simulators[8 * i + 0], pathToProfiles[i] + "Kingsley.map", pathToProfiles[i] + ".Kingsley.mtr");
            this.logAndSaveReports(simulators[8 * i + 1], pathToProfiles[i] + "Fibonacci.map", pathToProfiles[i] + ".Fibonacci.mtr");
            this.logAndSaveReports(simulators[8 * i + 2], pathToProfiles[i] + "Segregated10.map", pathToProfiles[i] + ".Segregated10.mtr");
            this.logAndSaveReports(simulators[8 * i + 3], pathToProfiles[i] + "Exact.map", pathToProfiles[i] + ".Exact.mtr");
            this.logAndSaveReports(simulators[8 * i + 4], pathToProfiles[i] + "Kingsley.Farthest.map", pathToProfiles[i] + ".Kingsley.Farthest.mtr");
            this.logAndSaveReports(simulators[8 * i + 5], pathToProfiles[i] + "Fibonacci.Farthest.map", pathToProfiles[i] + ".Fibonacci.Farthest.mtr");
            this.logAndSaveReports(simulators[8 * i + 6], pathToProfiles[i] + "Segregated10.Farthest.map", pathToProfiles[i] + ".Segregated10.Farthest.mtr");
            this.logAndSaveReports(simulators[8 * i + 7], pathToProfiles[i] + "Exact.Farthest.map", pathToProfiles[i] + ".Exact.Farthest.mtr");
        }
    }

    public void logAndSaveReports(Simulator simulator, String mapPath, String metrPath) throws IOException {
        String mapAsString = simulator.drawAllocatorMap();
        String reportAsString = simulator.getMetrics().report();
        logger.info(mapAsString);
        logger.info(reportAsString);
        BufferedWriter writer = null;
        logger.info("Saving map ...");
        writer = new BufferedWriter(new FileWriter(new File(mapPath)));
        writer.write(mapAsString);
        writer.flush();
        writer.close();
        logger.info("Saving metrics ...");
        writer = new BufferedWriter(new FileWriter(new File(metrPath)));
        writer.write(reportAsString);
        writer.flush();
        writer.close();
        logger.info("DONE.");
    }
}

