/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.zdt;

import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.VariableReal;
import jeco.lib.problems.zdt.ZDT;

public class ZDT2
extends ZDT {
    public ZDT2(Integer numberOfVariables) {
        super("ZDT2", numberOfVariables);
        for (int i = 0; i < numberOfVariables; ++i) {
            this.lowerBound[i] = 0.0;
            this.upperBound[i] = 1.0;
        }
    }

    public ZDT2() {
        this(30);
    }

    public void evaluate(Solution solution) {
        VariableReal[] variables = (VariableReal[])solution.getVariables();
        double f1 = (Double)variables[0].getValue();
        double g = 0.0;
        for (int j = 1; j < this.numberOfVariables; ++j) {
            g += ((Double)variables[j].getValue()).doubleValue();
        }
        g *= 9.0;
        g /= (double)(this.numberOfVariables - 1);
        double h = 1.0 - f1 / (g += 1.0) * (f1 / g);
        solution.setObjective(0, f1);
        solution.setObjective(1, g * h);
    }

    public Solutions computeParetoOptimalFront(int n) {
        Solutions result = new Solutions();
        for (int i = 0; i < n; ++i) {
            Solution sol = new Solution(this);
            double temp = 0.0 + 1.0 * (double)i / (double)(n - 1);
            sol.getVariable(0).setValue(temp);
            for (int j = 1; j < this.numberOfVariables; ++j) {
                sol.getVariable(j).setValue(0.0);
            }
            this.evaluate(sol);
            result.add(sol);
        }
        result.keepParetoNonDominated(new SolutionDominance());
        return result;
    }
}

