/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.algorithms;

import moea.commons.Population;
import moea.commons.assigner.AssignerSpea2;
import moea.commons.comparator.ComparatorFitness;
import moea.moga.algorithms.Moea;
import moea.moga.genome.Chromosome;
import moea.moga.selector.BinarySelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spea2
extends Moea {
    protected Population<Chromosome> pop2;
    protected int pop2SizeMax;
    protected AssignerSpea2<Chromosome> assigner;

    public Spea2(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation, int migrationRate) {
        super(name, popIni, maxGenerations, probabilityOfCrossover, probabilityOfMutation, migrationRate);
        this.selector = new BinarySelector(ComparatorFitness.getInstance());
        this.pop2 = new Population();
        this.pop2SizeMax = this.popSizeMax;
        this.assigner = new AssignerSpea2((int)Math.sqrt(this.popSizeMax + this.pop2SizeMax));
    }

    public Spea2(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation) {
        this(name, popIni, maxGenerations, probabilityOfCrossover, probabilityOfMutation, 1);
    }

    @Override
    public void step() {
        Population<Chromosome> pop12 = new Population<Chromosome>();
        pop12.add(this.pop);
        pop12.add(this.pop2);
        int extSize = this.externalIndividuals.size();
        if (extSize > 0) {
            for (int i = 0; i < extSize; ++i) {
                pop12.add(this.externalIndividuals.get(i));
            }
            this.externalIndividuals.clear();
        }
        this.assigner.assignFitness(pop12);
        Population<Chromosome> pop12Reduced = this.assigner.reduceByFitness(pop12);
        if (pop12Reduced.size() < this.pop2SizeMax) {
            this.assigner.expand(pop12Reduced, pop12, this.pop2SizeMax - pop12Reduced.size());
        } else if (pop12Reduced.size() > this.pop2SizeMax) {
            pop12Reduced = this.assigner.reduce(pop12Reduced, this.pop2SizeMax);
        }
        if (this.currentGeneration == this.maxGenerations - 1) {
            this.pop = pop12Reduced;
        } else {
            this.pop2 = pop12Reduced;
            this.pop = this.generate(this.pop2);
        }
        ++this.currentGeneration;
    }
}

