/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.examples;

import ext.number.ValModPosInt;
import ext.number.Value;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import moea.commons.Population;
import moea.commons.comparator.ComparatorPareto;
import moea.moga.algorithms.Moea;
import moea.moga.algorithms.Vega;
import moea.moga.genome.Chromosome;
import moea.moga.genome.ChromosomeWithMapping;

public class ChowPaper
extends ChromosomeWithMapping {
    private static final long serialVersionUID = 1L;
    protected static KindOfFunction kindOfFunction;
    protected static int numTrials;

    public ChowPaper clone() {
        ChowPaper clone = new ChowPaper(this);
        return clone;
    }

    public ChowPaper() {
    }

    public ChowPaper(ChowPaper src) {
        super(src);
    }

    public static void initializeProblem(String[] args) throws Exception {
        String function = args[0];
        N = 1;
        M = Integer.valueOf(args[1]);
        if (M != 40 && M != 60) {
            throw new Exception("Second argument must be 40 or 60");
        }
        if (function.equals("UGLY")) {
            kindOfFunction = KindOfFunction.UGLY;
        } else if (function.equals("BAD")) {
            kindOfFunction = KindOfFunction.BAD;
        } else if (function.equals("TRAP4")) {
            kindOfFunction = KindOfFunction.TRAP4;
        } else if (function.equals("TRAP8")) {
            kindOfFunction = KindOfFunction.TRAP8;
        } else {
            throw new Exception("First argument must be UGLY, BAD, TRAP4 OR TRAP8");
        }
        try {
            ValModPosInt.setModulus(2);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        xL = new Value[M];
        xU = new Value[M];
        for (int j = 0; j < M; ++j) {
            ChowPaper.xL[j] = new ValModPosInt(0);
            ChowPaper.xU[j] = new ValModPosInt(1);
        }
    }

    public void evaluate() {
        for (int i = 0; i < N; ++i) {
            this.objectiveVector.set(i, 0.0);
        }
        int groups = M / 4;
        double fitnessG = 0.0;
        double acumulador = 0.0;
        int[] auxiliar = new int[4];
        for (int i = 0; i < groups; ++i) {
            for (int j = 0; j < 4; ++j) {
                auxiliar[j] = this.x[this.mapping[groups * j + i]].intValue();
            }
            int valorDecimal = 0;
            int base2 = 1;
            for (int m = 3; m >= 0; --m) {
                valorDecimal += auxiliar[m] * base2;
                base2 *= 2;
            }
            if (kindOfFunction == KindOfFunction.UGLY) {
                acumulador += ChowPaper.ugly(valorDecimal);
                continue;
            }
            acumulador += ChowPaper.bad(valorDecimal);
        }
        fitnessG = -acumulador;
        this.objectiveVector.set(0, fitnessG);
    }

    public static void printStats(BufferedWriter out, int[] array) throws Exception {
        int optimalValues = 0;
        int generations = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0) continue;
            ++optimalValues;
            generations += array[i];
        }
        double avg = 1.0 * (double)generations / (double)optimalValues;
        out.write("Optimal values: " + optimalValues + "\n");
        out.write("Avg. Generations: " + avg + "\n");
    }

    public static void main(String[] args) throws Exception {
        args = new String[]{"UGLY", "40", "10000", "200"};
        if (args.length != 4) {
            System.out.println("Arguments: Function NumBits Evaluations Size");
            System.out.println("Recommended: [UGLY|BAD] [40|60] 10000 200");
            System.out.println("Recommended: [UGLY|BAD] [40|60] 50000 2000");
            return;
        }
        ChowPaper.initializeProblem(args);
        BufferedWriter out = new BufferedWriter(new FileWriter(new File("ChowPaper_" + args[0] + "_" + args[1] + "_" + args[2] + "_" + args[3] + ".txt")));
        int[] genToMax = new int[numTrials];
        for (int i = 0; i < numTrials; ++i) {
            genToMax[i] = 0;
            out.write("Iteration number: " + i + "...");
            System.out.print("Iteration number: " + i + "...");
            Population<Chromosome> popIni = new Population<Chromosome>();
            for (int k = 0; k < Integer.valueOf(args[3]); ++k) {
                ChowPaper individual = new ChowPaper();
                popIni.add(individual);
            }
            Vega algorithm = new Vega("Vega", popIni, Integer.valueOf(args[2]), 0.6, 1.0 / (double)M);
            while (!algorithm.done() && genToMax[i] == 0) {
                ((Moea)algorithm).step();
                Chromosome ind = algorithm.getPopulation().getBestIndividual(ComparatorPareto.getInstance());
                double value = (Double)ind.getObjectiveVector().get(0);
                if (!ChowPaper.isOptimal(value)) continue;
                genToMax[i] = algorithm.getCurrentGeneration();
            }
            out.write("done with optimal at generation: " + genToMax[i] + "\n");
            System.out.println("done with optimal at generation: " + genToMax[i]);
        }
        ChowPaper.printStats(out, genToMax);
        out.flush();
        out.close();
    }

    public static boolean isOptimal(double value) {
        return value <= -(30.0 * (double)M) / 4.0;
    }

    public static double bad(int parametro) {
        double res = 0.0;
        switch (parametro) {
            case 0: {
                res = 18.0;
                break;
            }
            case 1: {
                res = 6.0;
                break;
            }
            case 2: {
                res = 26.0;
                break;
            }
            case 3: {
                res = 16.0;
                break;
            }
            case 4: {
                res = 24.0;
                break;
            }
            case 5: {
                res = 14.0;
                break;
            }
            case 6: {
                res = 28.0;
                break;
            }
            case 7: {
                res = 20.0;
                break;
            }
            case 8: {
                res = 4.0;
                break;
            }
            case 9: {
                res = 30.0;
                break;
            }
            case 10: {
                res = 12.0;
                break;
            }
            case 11: {
                res = 0.0;
                break;
            }
            case 12: {
                res = 10.0;
                break;
            }
            case 13: {
                res = 2.0;
                break;
            }
            case 14: {
                res = 22.0;
                break;
            }
            case 15: {
                res = 8.0;
                break;
            }
            default: {
                res = 0.0;
            }
        }
        return res;
    }

    public static double ugly(int parametro) {
        double res = 0.0;
        switch (parametro) {
            case 0: {
                res = 28.0;
                break;
            }
            case 1: {
                res = 26.0;
                break;
            }
            case 2: {
                res = 24.0;
                break;
            }
            case 3: {
                res = 18.0;
                break;
            }
            case 4: {
                res = 22.0;
                break;
            }
            case 5: {
                res = 16.0;
                break;
            }
            case 6: {
                res = 14.0;
                break;
            }
            case 7: {
                res = 0.0;
                break;
            }
            case 8: {
                res = 20.0;
                break;
            }
            case 9: {
                res = 12.0;
                break;
            }
            case 10: {
                res = 10.0;
                break;
            }
            case 11: {
                res = 2.0;
                break;
            }
            case 12: {
                res = 8.0;
                break;
            }
            case 13: {
                res = 4.0;
                break;
            }
            case 14: {
                res = 6.0;
                break;
            }
            case 15: {
                res = 30.0;
                break;
            }
            default: {
                res = 0.0;
            }
        }
        return res;
    }

    static {
        numTrials = 100;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum KindOfFunction {
        UGLY,
        BAD,
        TRAP4,
        TRAP8;

    }
}

