/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.examples;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import moea.commons.Population;
import moea.moga.algorithms.Moea;
import moea.moga.algorithms.Nsga2;
import moea.moga.algorithms.Spea2;
import moea.moga.examples.Profile;
import moea.moga.genome.Chromosome;

public class ProfileAutoThreads
extends Profile {
    private static final long serialVersionUID = 1L;

    /*
     * Could not resolve type clashes
     */
    public static void main(String[] args) throws Exception {
        String outDir = ".";
        if (args.length < 3) {
            System.out.println("Usage:");
            System.out.println("java -jar ProfileAutoThreads.jar <XML-PROFILE> <NumTrials:1..Inf> <MaxGenerations:1..Inf>");
            args = new String[]{"Physics.pro", "1", "8000"};
            outDir = "D:/jlrisco/Trabajo/MisPapers/IEEE T EVOLUT COMPUT/2007/Results";
            return;
        }
        String proPath = outDir + File.separator + args[0];
        Integer numberOfTrials = Integer.valueOf(args[1]);
        Integer maxGenerations = Integer.valueOf(args[2]);
        Integer[] popSizes = new Integer[]{1024, 512, 256, 128};
        Profile.initializeProblem(proPath);
        for (int indexPop = 0; indexPop < popSizes.length; ++indexPop) {
            int migrationRate = Profile.getMigrationRate(popSizes[indexPop]);
            for (int workStations = 16; workStations > 0; --workStations) {
                String algorithmName = popSizes[indexPop] + "." + workStations;
                System.out.println("=========================================");
                System.out.println("Algorithm: " + algorithmName);
                System.out.println("=========================================");
                int numThreads = 2 * workStations;
                int subPopSize = Profile.getSubPopSize(popSizes[indexPop], numThreads);
                BufferedWriter loggerMetrics = new BufferedWriter(new FileWriter(new File(proPath + "." + algorithmName + ".MetricsAvg")));
                ArrayList<Double> spreads = new ArrayList<Double>();
                ArrayList<Double> spacings = new ArrayList<Double>();
                ArrayList<Double> times = new ArrayList<Double>();
                ArrayList<Double> nds = new ArrayList<Double>();
                for (int i = 0; i < numberOfTrials; ++i) {
                    int j;
                    BufferedWriter loggerPop = new BufferedWriter(new FileWriter(new File(proPath + "." + algorithmName + "." + i)));
                    System.out.println("Iteration number: " + i);
                    ArrayList<Nsga2> islands = new ArrayList<Nsga2>();
                    for (j = 0; j < numThreads; ++j) {
                        Population<Chromosome> popIni = new Population<Chromosome>();
                        for (int k = 0; k < subPopSize; ++k) {
                            ProfileAutoThreads individual = new ProfileAutoThreads();
                            popIni.add(individual);
                        }
                        Moea island = null;
                        island = j % 2 == 0 ? new Nsga2("Island" + j, popIni, maxGenerations, 0.8, 0.01, migrationRate) : new Spea2("Island" + j, popIni, maxGenerations, 0.8, 0.01, migrationRate);
                        islands.add((Nsga2)island);
                    }
                    if (numThreads > 1) {
                        for (j = 1; j < numThreads; ++j) {
                            ((Moea)islands.get(j - 1)).addNeighbor((Moea)islands.get(j));
                        }
                        ((Moea)islands.get(numThreads - 1)).addNeighbor((Moea)islands.get(0));
                    }
                    double start = System.currentTimeMillis();
                    for (Moea island : islands) {
                        island.start();
                    }
                    for (Moea island : islands) {
                        island.join();
                    }
                    double end = System.currentTimeMillis();
                    Population<Chromosome> pop = new Population<Chromosome>();
                    for (Moea island : islands) {
                        pop.add(island.getPopulation());
                    }
                    pop.keepNonDominated();
                    spreads.add(pop.calculateSpread());
                    spacings.add(pop.calculateSpacing());
                    nds.add(1.0 * (double)pop.size());
                    times.add((end - start) / 1000.0);
                    System.out.println("Spread: " + spreads.get(spreads.size() - 1));
                    System.out.println("Spacing: " + spacings.get(spacings.size() - 1));
                    System.out.println("NDs: " + nds.get(nds.size() - 1));
                    System.out.println("Time: " + (end - start) / 1000.0);
                    System.out.println("done.");
                    loggerPop.write(ProfileAutoThreads.PopulationToString(pop));
                    loggerPop.flush();
                    loggerPop.close();
                }
                double spreadMean = ProfileAutoThreads.calculateMean(spreads);
                double spreadStd = ProfileAutoThreads.calculateStd(spreads, spreadMean);
                double spacingMean = ProfileAutoThreads.calculateMean(spacings);
                double spacingStd = ProfileAutoThreads.calculateStd(spacings, spacingMean);
                double ndsMean = ProfileAutoThreads.calculateMean(nds);
                double ndsStd = ProfileAutoThreads.calculateStd(nds, ndsMean);
                double timeMean = ProfileAutoThreads.calculateMean(times);
                double timeStd = ProfileAutoThreads.calculateStd(times, timeMean);
                loggerMetrics.write("Spread(Mean,Std):\t" + spreadMean + "\t" + spreadStd + "\n");
                loggerMetrics.write("Spacing(Mean,Std):\t" + spacingMean + "\t" + spacingStd + "\n");
                loggerMetrics.write("NDs(Mean,Std):\t" + ndsMean + "\t" + ndsStd + "\n");
                loggerMetrics.write("Time(Mean,Std):\t" + timeMean + "\t" + timeStd + "\n");
                loggerMetrics.flush();
                loggerMetrics.close();
            }
        }
    }
}

