/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.genome;

import moea.moga.genome.Chromosome;

public abstract class ChromosomeWithMapping
extends Chromosome {
    protected int[] mapping = new int[M];
    protected static MappingMethod mappingMethod;

    public abstract ChromosomeWithMapping clone();

    public ChromosomeWithMapping() {
        for (int i = 0; i < M; ++i) {
            this.mapping[i] = (int)((double)M * Math.random());
        }
    }

    public ChromosomeWithMapping(ChromosomeWithMapping src) {
        super(src);
        for (int i = 0; i < M; ++i) {
            this.mapping[i] = src.mapping[i];
        }
    }

    public boolean crossover(double probabilityOfCrossover, Chromosome dad, Chromosome sister, Chromosome brother) {
        boolean cross = super.crossover(probabilityOfCrossover, dad, sister, brother);
        if (mappingMethod == MappingMethod.NONE) {
            return cross;
        }
        ChromosomeWithMapping dadWithMapping = (ChromosomeWithMapping)dad;
        ChromosomeWithMapping sisterWithMapping = (ChromosomeWithMapping)sister;
        ChromosomeWithMapping brotherWithMapping = (ChromosomeWithMapping)brother;
        if (cross) {
            int pos;
            int j;
            for (j = pos = 1 + (int)((double)(M - 1) * Math.random()); j < M; ++j) {
                sisterWithMapping.mapping[j] = dadWithMapping.mapping[j];
            }
            for (j = pos; j < M; ++j) {
                brotherWithMapping.mapping[j] = this.mapping[j];
            }
            sister.invalidateScores();
            brother.invalidateScores();
            return true;
        }
        return false;
    }

    public void mutate(double probabilityOfMutation) {
        int j;
        int temp;
        int posMax;
        int posMin;
        int pos2;
        super.mutate(probabilityOfMutation);
        if (mappingMethod == MappingMethod.NONE) {
            this.invalidateScores();
            return;
        }
        for (int i = 0; i < M; ++i) {
            if (Math.random() < 0.2 * probabilityOfMutation) {
                this.mapping[i] = (int)(Math.random() * (double)M);
            }
            if (mappingMethod != MappingMethod.EMMRS || !(Math.random() < probabilityOfMutation)) continue;
            pos2 = (int)(Math.random() * (double)M);
            posMin = Math.min(i, pos2);
            posMax = Math.max(i, pos2);
            temp = this.mapping[posMin];
            for (j = posMax; j > posMin + 1; --j) {
                this.mapping[j] = this.mapping[j - 1];
            }
            if (posMin + 1 >= M) continue;
            this.mapping[posMin + 1] = temp;
        }
        if (mappingMethod == MappingMethod.EMM && Math.random() < probabilityOfMutation) {
            int pos1 = (int)(Math.random() * (double)this.mapping.length);
            pos2 = (int)(Math.random() * (double)this.mapping.length);
            posMin = Math.min(pos1, pos2);
            posMax = Math.max(pos1, pos2);
            temp = this.mapping[posMin];
            for (j = posMax; j > posMin + 1; --j) {
                this.mapping[j] = this.mapping[j - 1];
            }
            if (posMin + 1 < this.mapping.length) {
                this.mapping[posMin + 1] = temp;
            }
        }
        this.invalidateScores();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MappingMethod {
        NONE,
        EMM,
        EMMRS;

    }
}

