/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.Canvas;

import FitnessEvaluation.FitnessFunction;
import Individuals.Individual;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Paint
implements FitnessFunction {
    private JFrame window = null;
    private Painting painting = null;
    private double best = Double.MAX_VALUE;

    public void setProperties(Properties p) {
    }

    public void getFitness(Individual i) {
        this.init();
        this.painting.paint(i.getPhenotype().getString());
        double result = this.painting.evaluate();
        if (result < this.best) {
            this.best = result;
            this.painting.mirror();
        }
        this.painting.invalidate();
        i.getFitness().setDouble(result);
    }

    public boolean canCache() {
        return true;
    }

    private void init() {
        if (this.window != null) {
            return;
        }
        this.window = new JFrame();
        this.painting = new Painting();
        this.painting.setSize(256, 128);
        this.window.setDefaultCloseOperation(3);
        this.window.setSize(256, 128);
        this.window.setVisible(true);
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add(this.painting);
    }

    class Painting
    extends JPanel {
        private BufferedImage image = new BufferedImage(64, 64, 1);
        private BufferedImage bestImage = new BufferedImage(64, 64, 1);

        Painting() {
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.render(graphics);
        }

        public void paint(String actionString) {
            int[] pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            int index = 0;
            String[] actions = actionString.split(" ");
            if (actions.length % 6 != 0) {
                return;
            }
            int[] colour = new int[actions.length / 6];
            int i = 0;
            while (i < actions.length) {
                float r = Float.parseFloat("0." + actions[i + 0] + actions[i + 1]);
                float g = Float.parseFloat("0." + actions[i + 2] + actions[i + 3]);
                float b = Float.parseFloat("0." + actions[i + 4] + actions[i + 5]);
                colour[index] = 0xFF000000 | (int)(255.0f * r) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * b);
                i += 6;
                ++index;
            }
            index = 0;
            for (int pixel = 0; pixel < pixels.length; ++pixel) {
                pixels[pixel] = colour[index];
                if (++index < colour.length) continue;
                index = 0;
            }
            this.render(this.getGraphics());
        }

        public void mirror() {
            this.bestImage.getGraphics().drawImage(this.image, 0, 0, null);
        }

        private void render(Graphics graphics) {
            graphics.drawImage(this.image, 0, 0, Paint.this.window.getWidth() / 2, Paint.this.window.getHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
            graphics.drawImage(this.bestImage, Paint.this.window.getWidth() / 2, 0, Paint.this.window.getWidth(), Paint.this.window.getHeight(), 0, 0, this.bestImage.getWidth(), this.bestImage.getHeight(), null);
        }

        public double evaluate() {
            int[] pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            int pixel = 0;
            double result = 0.0;
            int[] r = new int[256];
            int[] g = new int[256];
            int[] b = new int[256];
            for (int y = 0; y < this.image.getHeight(); ++y) {
                for (int x = 0; x < this.image.getWidth(); ++x) {
                    double thisResult = 0.0;
                    int account = 0;
                    if (x > 0) {
                        thisResult += this.evaluate(pixels[pixel], pixels[pixel - 1]);
                        ++account;
                    }
                    if (x < this.image.getWidth() - 1) {
                        thisResult += this.evaluate(pixels[pixel], pixels[pixel + 1]);
                        ++account;
                    }
                    if (y > 0) {
                        thisResult += this.evaluate(pixels[pixel], pixels[pixel - this.image.getWidth()]);
                        ++account;
                    }
                    if (y < this.image.getHeight() - 1) {
                        thisResult += this.evaluate(pixels[pixel], pixels[pixel + this.image.getWidth()]);
                        ++account;
                    }
                    int n = (pixels[pixel] & 0xFF0000) >> 16;
                    r[n] = r[n] + 1;
                    int n2 = (pixels[pixel] & 0xFF00) >> 8;
                    g[n2] = g[n2] + 1;
                    int n3 = pixels[pixel] & 0xFF;
                    b[n3] = b[n3] + 1;
                    result += thisResult / (double)account;
                    ++pixel;
                }
            }
            result /= (double)pixel;
            result = this.evaluate(r, g, b);
            return result;
        }

        private double evaluate(int pixela, int pixelb) {
            int r = ((pixela & 0xFF0000) >> 16) - ((pixelb & 0xFF0000) >> 16);
            int g = ((pixela & 0xFF00) >> 8) - ((pixelb & 0xFF00) >> 8);
            int b = (pixela & 0xFF) - (pixelb & 0xFF);
            int a = Math.abs(r + g + b);
            if (a <= 10) {
                a = (10 - a) * (10 - a);
            }
            return a;
        }

        private double evaluate(int[] r, int[] g, int[] b) {
            double st;
            double sr = this.stdDev(r);
            double sg = this.stdDev(g);
            double sb = this.stdDev(b);
            if (sr < sg) {
                st = sr;
                sr = sg;
                sg = st;
            }
            if (sr < sb) {
                st = sr;
                sr = sb;
                sb = st;
            }
            if (sg < sb) {
                st = sg;
                sg = sb;
                sg = st;
            }
            return sr + sg / 2.0 + sb / 4.0;
        }

        private double stdDev(int[] v) {
            int i;
            double[] w = new double[v.length];
            double mean = 0.0;
            for (i = 0; i < v.length; ++i) {
                mean += (double)v[i];
            }
            mean /= (double)v.length;
            for (i = 0; i < v.length; ++i) {
                w[i] = Math.pow((double)v[i] - mean, 2.0);
            }
            mean = 0.0;
            for (i = 0; i < w.length; ++i) {
                mean += w[i];
            }
            return Math.sqrt(mean /= (double)w.length);
        }
    }
}

