/*
 * Decompiled with CFR 0.152.
 */
package Fractal;

import Fractal.LSystem2;
import Fractal.LSystem2Config;
import Fractal.LSystem2FDBoxCounting;
import Fractal.protoComp;
import Fractal.protoCompContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class guiComp
extends JFrame
implements ActionListener,
Comparator<LSystem2Config>,
LSystem2Config.SelectAction {
    public static final int SM_PHENOTYPE = 0;
    public static final int SM_FITNESS = 1;
    public static final int SM_FRACTALDIMENSION = 2;
    public static int sortMethod = 1;
    public static final int LF_NOFIT = 0;
    public static final int LF_FIT = 1;
    public static final int LF_UNFIT = 2;
    private static Rectangle saveBounds;
    private static int saveParents;
    private JPanel header;
    private JPanel body;
    private JPanel footer;
    private JLabel jLabel_tital;
    HashMap<String, LSystem2Config> coalesceGrammar = new HashMap();
    int[] fits;
    JSpinner numMaxParents;
    final String Grammar1 = "F=F[+F]F[-F]F+F-F";
    private boolean stillRunning = true;

    public guiComp(String[] arrayPheno, String[] arrayDepth, String[] arrayAngle, double[] arrayFitns, int valids, int generation, int generations) {
        for (int i = 0; i < arrayPheno.length; ++i) {
            String key = this.namePheno(arrayPheno[i], arrayDepth[i], arrayAngle[i]);
            if (!this.coalesceGrammar.containsKey(key)) {
                this.coalesceGrammar.put(key, new LSystem2Config(i, arrayPheno[i], Integer.parseInt(arrayDepth[i]), Float.parseFloat(arrayAngle[i]), arrayFitns[i]));
                continue;
            }
            LSystem2Config config = this.coalesceGrammar.get(key);
            config.indexes.add(i);
            if (!(config.fitness > arrayFitns[i])) continue;
            config.fitness = arrayFitns[i];
        }
        this.fits = new int[arrayPheno.length];
        this.init(generation, generations);
        this.pack();
        this.setVisible(true);
    }

    private String namePheno(String pheno, String depth, String angle) {
        LSystem2 lSystem = new LSystem2(pheno, Integer.parseInt(depth), Float.parseFloat(angle));
        return lSystem.getDerivedGrammar() + ":" + (int)(lSystem.getAngle() * 1000.0f);
    }

    public void init(int generation, int generations) {
        this.initComponents(generation, generations);
    }

    private void initComponents(int generation, int generations) {
        this.header = new JPanel();
        this.body = new protoCompContainer();
        JScrollPane bodyScroll = new JScrollPane(this.body);
        this.footer = new JPanel();
        this.setDefaultCloseOperation(3);
        Dimension size = new Dimension(1000, 700);
        if (saveBounds != null) {
            super.setBounds(saveBounds);
            size.width = guiComp.saveBounds.width;
            size.height = guiComp.saveBounds.height;
        }
        super.setPreferredSize(size);
        super.setSize(size);
        this.setLayout(new BorderLayout());
        FlowLayout bodyLayout = new FlowLayout(0);
        FlowLayout footerLayout = new FlowLayout();
        this.body.setLayout(bodyLayout);
        this.footer.setLayout(footerLayout);
        super.setVisible(true);
        int w = this.getBestWidth();
        ArrayList<LSystem2Config> configs = new ArrayList<LSystem2Config>();
        for (LSystem2Config config : this.coalesceGrammar.values()) {
            configs.add(config);
        }
        Collections.sort(configs, this);
        for (LSystem2Config config : configs) {
            this.body.add(new protoComp(this, config, w));
        }
        JButton cmdStop = new JButton("Stop run");
        cmdStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                guiComp.this.cmdStop_onClick();
            }
        });
        JButton cmdGenerate = new JButton();
        cmdGenerate.setText("Generate");
        cmdGenerate.addActionListener(this);
        this.numMaxParents = new JSpinner(new SpinnerNumberModel(saveParents, 0, this.fits.length, 1));
        this.numMaxParents.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                saveParents = Integer.parseInt(guiComp.this.numMaxParents.getValue().toString());
            }
        });
        this.jLabel_tital = new JLabel();
        this.jLabel_tital.setFont(new Font("Lucida Grande", 1, 36));
        this.jLabel_tital.setText("GELsys");
        JLabel lblMaxParents = new JLabel("Maximum parents: ");
        JLabel lblGenerations = new JLabel("[" + generation + "] of [" + generations + "]");
        JButton cmdAbout = new JButton("About");
        cmdAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                guiComp.this.cmdAbout_onClick();
            }
        });
        this.add((Component)this.header, "North");
        this.add((Component)bodyScroll, "Center");
        this.add((Component)this.footer, "South");
        this.header.add(this.jLabel_tital);
        this.footer.add(cmdAbout);
        this.footer.add(new JSeparator(1));
        this.footer.add(lblMaxParents);
        this.footer.add(this.numMaxParents);
        this.footer.add(cmdGenerate);
        this.footer.add(lblGenerations);
        this.footer.add(new JSeparator(1));
        this.footer.add(cmdStop);
    }

    private int getBestWidth() {
        int width = super.getContentPane().getWidth() - 9;
        int height = super.getContentPane().getHeight() - 9;
        int layer = 2;
        double w = (double)this.coalesceGrammar.size() / (double)layer;
        while (10.0 + ((double)width / w + 25.0) * (double)layer < (double)height) {
            w = (double)this.coalesceGrammar.size() / (double)(++layer);
        }
        w = Math.ceil((double)this.coalesceGrammar.size() / (double)(layer - 1));
        if ((w = (double)width / w - 5.0) < 80.0) {
            w = 80.0;
        }
        if (w > 256.0) {
            w = 256.0;
        }
        return (int)w;
    }

    @Override
    public int compare(LSystem2Config o1, LSystem2Config o2) {
        switch (sortMethod) {
            case 0: {
                return this.comparePhenotype(o1, o2);
            }
            case 1: {
                if (o1.fitness < o2.fitness) {
                    return -1;
                }
                if (o1.fitness > o2.fitness) {
                    return 1;
                }
                return 0;
            }
            case 2: {
                return this.compareFractalDimension(o1, o2);
            }
        }
        return 0;
    }

    int comparePhenotype(LSystem2Config o1, LSystem2Config o2) {
        int i;
        int b1 = 0;
        int b2 = 0;
        boolean d = true;
        for (i = 0; i < o1.grammar.length(); ++i) {
            if (o1.grammar.charAt(i) != 'F') continue;
            ++b1;
        }
        for (i = 0; i < o2.grammar.length(); ++i) {
            if (o2.grammar.charAt(i) != 'F') continue;
            ++b2;
        }
        return b2 - b1;
    }

    int compareFractalDimension(LSystem2Config o1, LSystem2Config o2) {
        int b1 = (int)(new LSystem2FDBoxCounting(null, o1.grammar, o1.depth, o1.angle, 256).calcFractalDimension() * 1000.0);
        int b2 = (int)(new LSystem2FDBoxCounting(null, o2.grammar, o2.depth, o2.angle, 256).calcFractalDimension() * 1000.0);
        return b2 - b1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    public boolean stillRunning() {
        return this.stillRunning;
    }

    public int[] getGELSYSFitness() {
        for (LSystem2Config config : this.coalesceGrammar.values()) {
            if (config.select) {
                for (Integer index : config.indexes) {
                    this.fits[index.intValue()] = 1;
                }
                continue;
            }
            if (!config.purge) continue;
            for (Integer index : config.indexes) {
                this.fits[index.intValue()] = 2;
            }
        }
        return this.fits;
    }

    void cmdStop_onClick() {
        System.exit(0);
    }

    void cmdAbout_onClick() {
        new AboutDialog(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.stillRunning = false;
        saveBounds = super.getBounds();
        guiComp guiComp2 = this;
        synchronized (guiComp2) {
            super.notify();
        }
        super.dispose();
    }

    @Override
    public void selectPerformed() {
        int maxParents = Integer.parseInt(this.numMaxParents.getValue().toString());
        if (maxParents != 0) {
            for (LSystem2Config config : this.coalesceGrammar.values()) {
                if (!config.select || --maxParents != 0) continue;
                this.close();
            }
        }
    }

    static {
        saveParents = 0;
    }

    private class AboutDialog
    extends JDialog {
        public AboutDialog(Dialog owner) {
            super(owner);
            this.init();
        }

        public AboutDialog(Frame owner) {
            super(owner);
            this.init();
        }

        private void init() {
            JPanel guiAbout = new JPanel();
            JPanel guiText = new JPanel();
            JButton cmdOk = new JButton("OK");
            Dimension size = new Dimension(600, 450);
            super.setTitle("About GE LSystem");
            super.setPreferredSize(size);
            super.setSize(size);
            super.setBounds(super.getOwner().getX() + (super.getOwner().getWidth() - this.getWidth()) / 2, super.getOwner().getY() + (super.getOwner().getHeight() - this.getHeight()) / 2, size.width, size.height);
            super.setDefaultCloseOperation(2);
            super.setModal(true);
            super.setLayout(new BorderLayout());
            JLabel guiImage = new JLabel(new ImageIcon(ClassLoader.getSystemResource("UI/res/gelsbout.png")));
            guiImage.setBorder(BorderFactory.createEtchedBorder());
            guiImage.setBackground(Color.white);
            guiImage.setOpaque(true);
            guiAbout.setLayout(new BorderLayout());
            guiAbout.add((Component)guiImage, "Center");
            guiAbout.add((Component)guiText, "South");
            guiText.setLayout(new GridBagLayout());
            this.gridAdd(guiText, new JLabel("1."), 0, 0, 0.0);
            this.gridAdd(guiText, new Label("Individual LSystem. This can be clicked to view the LSystem in a separate window."), 1, 0, 1.0);
            this.gridAdd(guiText, new JLabel("2."), 0, 1, 0.0);
            this.gridAdd(guiText, new Label("Fitness: the smaller the red bar, the better the fitness of this LSystem. Each time an LSystem is chosen as a parent, its fitness improves."), 1, 1, 1.0);
            this.gridAdd(guiText, new JLabel("3."), 0, 2, 0.0);
            this.gridAdd(guiText, new Label("Choose which LSystems should become parents of the next generation. Parents will have their fitness improved.\nChoosing which to purge will forcably remove that LSystem from the next generation."), 1, 2, 1.0);
            this.gridAdd(guiText, new JLabel("4."), 0, 3, 0.0);
            this.gridAdd(guiText, new Label("Update the population based on the chosen parents. Parents will automatically be chosen if too few have been checked.\nMaximum parents specifies how many parents must be chosen before the next generation will be automatically generated. Setting maximum parents to zero will switch off automatic generation."), 1, 3, 1.0);
            this.gridAdd(guiText, new JLabel("5."), 0, 4, 0.0);
            this.gridAdd(guiText, new Label("Stop the run early. The run will normally end when the specified number of generations has been reached."), 1, 4, 1.0);
            cmdOk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    AboutDialog.super.dispose();
                }
            });
            super.add((Component)guiAbout, "Center");
            super.add((Component)cmdOk, "South");
            super.setVisible(true);
        }

        private void gridAdd(Container container, Container control, int gridX, int gridY, double weightX) {
            GridBagConstraints constraints = new GridBagConstraints(gridX, gridY, 1, 1, weightX, 0.0, 11, 1, new Insets(1, 1, 1, 1), 5, 5);
            constraints.anchor = 11;
            container.add((Component)control, constraints);
            if (control instanceof JLabel) {
                ((JLabel)control).setVerticalAlignment(1);
            }
        }

        private class Label
        extends JTextArea {
            public Label(String text) {
                super(text);
                this.setEditable(false);
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setBackground((Color)UIManager.get("Label.background"));
                this.setForeground((Color)UIManager.get("Label.foreground"));
                this.setFont((Font)UIManager.get("Label.font"));
            }
        }
    }
}

