/*
 * Decompiled with CFR 0.152.
 */
package Individuals;

import Individuals.AbstractIndividual;
import Individuals.FitnessPackage.BasicFitness;
import Individuals.FitnessPackage.Fitness;
import Individuals.GEChromosome;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.GEGrammar;
import Mapper.Mapper;

public class GEIndividual
extends AbstractIndividual {
    private Genotype genotype;
    private Phenotype phenotype;
    private GEGrammar grammar;
    private boolean mapped;
    private boolean valid;
    private int usedCodons;
    private int usedWraps;

    public GEIndividual() {
        this.mapped = false;
        this.valid = false;
        this.usedCodons = -1;
        this.usedWraps = -1;
    }

    public GEIndividual(GEGrammar g, Phenotype p, Genotype gen, Fitness f) {
        this.grammar = g;
        this.phenotype = p;
        this.genotype = gen;
        this.fitness = f;
        this.evaluated = false;
        this.mapped = false;
        this.valid = false;
        this.usedCodons = -1;
        this.usedWraps = -1;
        this.grammar.setPhenotype(this.phenotype);
        this.grammar.setGenotype(this.genotype.get(0));
        this.fitness.setIndividual(this);
        this.age = 0;
    }

    private GEIndividual(GEIndividual i) {
        super(i);
        this.grammar = new GEGrammar(i.grammar);
        this.phenotype = new Phenotype(i.phenotype);
        this.genotype = new Genotype(1);
        this.genotype.add(new GEChromosome((GEChromosome)i.getGenotype().get(0)));
        this.fitness = new BasicFitness(i.fitness.getDouble(), this);
        this.grammar.setGenotype(this.genotype.get(0));
        this.grammar.setPhenotype(this.phenotype);
    }

    public void invalidate() {
        this.usedCodons = -1;
        this.usedWraps = -1;
        this.valid = false;
        this.mapped = false;
        this.evaluated = false;
        this.age = 1;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    public void setMapped(boolean mapped) {
        this.mapped = mapped;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean b) {
        this.valid = b;
    }

    public void setUsedCodons(int usedCodons) {
        this.usedCodons = usedCodons;
    }

    public void setUsedWraps(int usedWraps) {
        this.usedWraps = usedWraps;
    }

    public void map(int map) {
        if (!this.mapped) {
            this.phenotype.clear();
            this.valid = this.grammar.genotype2Phenotype(true);
            this.mapped = true;
            this.usedCodons = this.grammar.getUsedCodons();
            this.usedWraps = this.grammar.getUsedWraps();
        }
    }

    public String getPhenotypeString(int map) {
        return this.phenotype.getString();
    }

    public Genotype getGenotype() {
        return this.genotype;
    }

    public Mapper getMapper() {
        return this.grammar;
    }

    public void setMapper(Mapper m) {
        this.grammar = (GEGrammar)m;
    }

    public void setGenotype(Genotype g) {
        this.invalidate();
        this.genotype = g;
        this.getMapper().setGenotype(this.genotype.get(0));
    }

    public void setPhenotype(Phenotype p) {
        this.phenotype = p;
    }

    public Phenotype getPhenotype() {
        return this.phenotype;
    }

    public Individual clone() {
        GEIndividual ind = new GEIndividual(this);
        ind.invalidate();
        return ind;
    }

    public String toString() {
        return this.phenotype.getString();
    }

    public int getUsedCodons() {
        return this.usedCodons;
    }

    public int getUsedWraps() {
        return this.usedWraps;
    }
}

