/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Algorithm.AbstractAlgorithm;
import Exceptions.BadParameterException;
import FitnessEvaluation.FitnessFunction;
import Individuals.Populations.Population;
import Main.State;
import Mapper.GEGrammar;
import Operator.Collector;
import Operator.Initialiser;
import Operator.JoinOperator;
import Operator.Module;
import Operator.Operations.CreationOperation;
import Operator.Operations.FullInitialiser;
import Operator.Operations.GrowInitialiser;
import Operator.Operations.RandomInitialiser;
import Operator.Operations.ReplacementOperation;
import Operator.Operations.SelectionOperation;
import Operator.Operations.StatisticsCollectionOperation;
import Operator.RampedFullGrowInitialiser;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import Util.Statistics.StatCatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;

public abstract class ParameterizedState
extends State {
    protected String propertiesFilePath;
    protected Initialiser initialiser;
    protected Properties properties;
    protected String stdOut;
    protected String stdErr;
    Collector collector;

    public abstract void setup(String[] var1);

    protected FitnessFunction getFitnessFunction(Properties p) {
        FitnessFunction fitnessFunction = null;
        String key = "fitness_function";
        try {
            String className = p.getProperty(key);
            if (className == null) {
                throw new BadParameterException(key);
            }
            Class<?> clazz = Class.forName(className);
            fitnessFunction = (FitnessFunction)clazz.newInstance();
            fitnessFunction.setProperties(p);
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].getName().equals(Stochastic.class.getName())) continue;
                ((Stochastic)((Object)fitnessFunction)).setRNG(this.rng);
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        return fitnessFunction;
    }

    protected Initialiser getInitialiser(GEGrammar g, RandomNumberGenerator rng, Properties p) {
        String key = "initialiser";
        try {
            String className = p.getProperty(key);
            if (className == null) {
                throw new BadParameterException(key);
            }
            Class<?> clazz = Class.forName(className);
            this.initialiser = (Initialiser)clazz.newInstance();
            if (clazz.getName().equals(RampedFullGrowInitialiser.class.getName())) {
                FullInitialiser fullInitialiser = new FullInitialiser(rng, g, p);
                GrowInitialiser growInitialiser = new GrowInitialiser(rng, g, p);
                ArrayList<CreationOperation> opL = new ArrayList<CreationOperation>();
                opL.add(fullInitialiser);
                opL.add(growInitialiser);
                ((RampedFullGrowInitialiser)this.initialiser).setOperations(opL);
            } else {
                RandomInitialiser randomInitialiser = new RandomInitialiser(rng, g, p);
                this.initialiser.setOperation(randomInitialiser);
            }
            this.initialiser.setProperties(p);
            this.initialiser.setRNG(rng);
            this.initialiser.init();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        return this.initialiser;
    }

    protected SelectionOperation getSelectionOperation(Properties p, RandomNumberGenerator rng) {
        SelectionOperation selectionOperation = null;
        String key = "selection_operation";
        try {
            String className = p.getProperty(key);
            if (className == null) {
                throw new BadParameterException(key);
            }
            Class<?> clazz = Class.forName(className);
            selectionOperation = (SelectionOperation)clazz.newInstance();
            selectionOperation.setProperties(p);
            ((Stochastic)((Object)selectionOperation)).setRNG(rng);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        return selectionOperation;
    }

    protected JoinOperator getJoinOperator(Properties p, RandomNumberGenerator rng, Population incPop, ReplacementOperation rO) {
        JoinOperator joinOperator = null;
        String className = "";
        String key = "replacement_type";
        if (p.getProperty(key).equals("steady_state")) {
            className = "Operator.MeritReplacementStrategy";
        } else if (p.getProperty(key).equals("generational")) {
            className = "Operator.SimpleReplacementStrategy";
        }
        key = "replacement_operator";
        try {
            if (p.getProperty(key) != null) {
                className = p.getProperty(key);
            }
            Class<?> clazz = Class.forName(className);
            joinOperator = (JoinOperator)clazz.newInstance();
            joinOperator.setIncomingPopulation(incPop);
            joinOperator.setOperation(rO);
            joinOperator.setRNG(rng);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        return joinOperator;
    }

    protected void init() {
        long st = System.currentTimeMillis();
        this.algorithm.init();
        long et = System.currentTimeMillis();
        this.collector = this.getCollector();
        if (this.collector != null) {
            ((StatisticsCollectionOperation)this.collector.getOperation()).printHeader();
            ((StatisticsCollectionOperation)this.collector.getOperation()).printStatsistics(et - st);
        }
    }

    protected void printStuff() {
        boolean printToFile = false;
        try {
            if (this.properties.getProperty("output") != null && !this.properties.getProperty("output").equals("") && !this.properties.getProperty("output").equals("false")) {
                printToFile = true;
            }
        }
        catch (Exception e) {
            System.out.println("No output option specified! Not printing to file");
        }
        this.collector.print(printToFile);
    }

    protected int run() {
        long st = System.currentTimeMillis();
        int its = 100;
        boolean stopWhenSolved = false;
        int fitnessEvaluationsPerGeneration = 1;
        try {
            String key = "generations";
            String value = this.properties.getProperty(key);
            if (value != null && !value.equals("")) {
                its = Integer.parseInt(value);
            }
            if ((value = this.properties.getProperty(key = "stopWhenSolved")) != null && !value.equals("") && value.equals("true")) {
                stopWhenSolved = true;
            }
            if (this.properties.getProperty("replacement_type", "").equals("steady_state")) {
                fitnessEvaluationsPerGeneration = Integer.parseInt(this.properties.getProperty("population_size", "10")) / 2;
                its *= fitnessEvaluationsPerGeneration;
            }
        }
        catch (Exception e) {
            System.out.println(e + " default generations:" + its);
        }
        for (int i = 1; i <= its; ++i) {
            if (this.collector == null || this.foundOptimum(stopWhenSolved, ((StatisticsCollectionOperation)this.collector.getOperation()).getStats())) continue;
            this.algorithm.step();
            long et = System.currentTimeMillis();
            if (i % fitnessEvaluationsPerGeneration != 0) continue;
            ((StatisticsCollectionOperation)this.collector.getOperation()).printStatsistics(et - st);
            st = System.currentTimeMillis();
        }
        return its;
    }

    protected boolean foundOptimum(boolean stopWhenSolved, StatCatcher stats) {
        boolean ret = false;
        if (stopWhenSolved && stats.getCurrentBestFitness() == 0.0) {
            ret = true;
        }
        return ret;
    }

    protected Collector getCollector() {
        if (((AbstractAlgorithm)this.getAlgorithm()).getLoopPipeline() != null) {
            Collection<Module> m = ((AbstractAlgorithm)this.getAlgorithm()).getLoopPipeline().getModules();
            for (Module mo : m) {
                if (!mo.getClass().getName().equals(Collector.class.getName())) continue;
                return (Collector)mo;
            }
        }
        return null;
    }

    protected boolean commandLineArgs(String[] args) {
        boolean ret = true;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            if (args[i].equals("-h")) {
                this.printProgramHelp();
                ret = false;
                continue;
            }
            if (args[i].equals("-properties_file") && i + 1 < args.length) {
                this.propertiesFilePath = args[i + 1];
                continue;
            }
            if (!args[i].equals("-v")) continue;
            this.printVersion();
            if (args.length != 1) continue;
            ret = false;
        }
        return ret;
    }

    void printVersion() {
        StringBuffer sb = new StringBuffer();
        sb.append("GEVA - Grammatical evolution in JAVA");
        sb.append(System.getProperty("line.separator"));
        sb.append("Version: 1");
        sb.append(System.getProperty("line.separator"));
        sb.append("Authors: Erik Hemberg, Conor Gilligan");
        sb.append(System.getProperty("line.separator"));
        sb.append("Developed by UCD Natural Computing Research & Applications group");
        sb.append(System.getProperty("line.separator"));
        sb.append("http://ncra.ucd.ie");
        System.out.println(sb.toString());
    }

    void printProgramHelp() {
        try {
            File f = new File(this.propertiesFilePath);
            FileInputStream is = new FileInputStream(f);
            this.properties = new Properties();
            this.properties.load(is);
            System.out.println("Commandline arguments");
            System.out.println("\t-h for help");
            System.out.println("\t-v for version");
        }
        catch (IOException e) {
            System.out.println(e + " no default properties file at " + this.propertiesFilePath);
        }
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            System.out.println("\t-" + e.nextElement());
        }
    }

    protected void readProperties(String[] args) {
        try {
            this.properties = new Properties();
            File f = new File(this.propertiesFilePath);
            if (!f.exists()) {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                InputStream in = loader.getResourceAsStream(this.propertiesFilePath);
                this.properties.load(in);
                System.out.println("Loading properties from ClassLoader and: " + this.propertiesFilePath);
            } else {
                FileInputStream is = new FileInputStream(f);
                this.properties.load(is);
                System.out.println("Loading properties from file system: " + this.propertiesFilePath);
            }
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].startsWith("-") || args.length <= i + 1 || args[i].equals("-v")) continue;
                    this.properties.setProperty(args[i].substring(1), args[i + 1]);
                    ++i;
                }
            }
            Enumeration<Object> e = this.properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.out.println(key + "=" + this.properties.getProperty(key, "Not defined"));
            }
        }
        catch (IOException e) {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            InputStream in = loader.getResourceAsStream(this.propertiesFilePath);
            try {
                this.properties.load(in);
            }
            catch (Exception ex) {
                System.err.println("Properties reading output caught:" + ex);
            }
            System.err.println(MessageFormat.format("Using default: {0} Bad:{1} Could not load:{2}", this.propertiesFilePath, this.propertiesFilePath, e));
        }
        catch (Exception e) {
            System.err.println("Could not commandline argument:" + e + " properties path:" + this.propertiesFilePath);
        }
    }
}

