/*
 * Decompiled with CFR 0.152.
 */
package Operator;

import Individuals.Individual;
import Individuals.Populations.Population;
import Operator.JoinOperator;
import Operator.Operations.EliteReplacementOperation;
import Operator.Operations.Operation;
import Util.Random.RandomNumberGenerator;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EliteReplacementOperator
extends JoinOperator {
    private EliteReplacementOperation replacementOperation;

    public EliteReplacementOperator(RandomNumberGenerator rng, Population incPop, EliteReplacementOperation rO) {
        super(rng, incPop);
        this.replacementOperation = rO;
    }

    @Override
    public void perform() {
        this.replacementOperation.doOperation(this.incomingPopulation.getAll());
        this.trimPopulation(this.population.getAll());
        this.population.addAll(this.incomingPopulation);
        Collections.sort(this.population.getAll());
    }

    private void trimPopulation(List<Individual> operand) {
        Collections.sort(operand);
        int cnt = operand.size();
        int cut = operand.size() - this.incomingPopulation.size();
        while (cnt > cut && cnt > 0) {
            operand.remove(--cnt);
        }
    }

    @Override
    public void setOperation(Operation op) {
        this.replacementOperation = (EliteReplacementOperation)op;
    }

    @Override
    public Operation getOperation() {
        return this.replacementOperation;
    }
}

