/*
 * Decompiled with CFR 0.152.
 */
package Operator;

import Exceptions.BadParameterException;
import Individuals.Individual;
import Individuals.Populations.Population;
import Individuals.Populations.SimplePopulation;
import Operator.Creator;
import Operator.Operations.CreationOperation;
import Operator.Operations.Operation;
import Operator.SourceModule;
import Util.Random.RandomNumberGenerator;
import java.util.Iterator;
import java.util.Properties;

public class Initialiser
extends SourceModule
implements Creator {
    protected CreationOperation operation;

    public Initialiser(RandomNumberGenerator rng, int size, CreationOperation op) {
        super(rng, size);
        this.operation = op;
        this.init();
    }

    public Initialiser(RandomNumberGenerator rng, CreationOperation op, Properties p) {
        super(rng, p);
        this.operation = op;
        this.init();
    }

    public Initialiser() {
    }

    public void init() {
        this.population = new SimplePopulation();
        for (int i = 0; i < this.size; ++i) {
            this.population.add(this.operation.createIndividual());
        }
    }

    public void setProperties(Properties p) {
        int value = Integer.parseInt("10");
        String key = "population_size";
        try {
            value = Integer.parseInt(p.getProperty(key));
            if (value < 1) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            p.setProperty(key, "10");
            System.out.println(e + " using default: " + "10");
        }
        this.setSize(value);
    }

    public Population getPopulation() {
        return this.population;
    }

    public void perform() {
        Iterator<Individual> iIt = this.population.iterator();
        while (iIt.hasNext()) {
            this.operation.doOperation(iIt.next());
        }
    }

    public void setOperation(Operation op) {
        this.operation = (CreationOperation)op;
    }

    public Operation getOperation() {
        return this.operation;
    }
}

