/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.BadParameterException;
import Individuals.Individual;
import Operator.Operations.Operation;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CrossoverOperation
implements Operation,
Stochastic {
    double probability;
    RandomNumberGenerator rand;

    @Override
    public abstract void doOperation(List<Individual> var1);

    CrossoverOperation(double prob, RandomNumberGenerator rng) {
        this.probability = prob;
        this.rand = rng;
    }

    CrossoverOperation(RandomNumberGenerator rng, Properties p) {
        this.setProperties(p);
        this.rand = rng;
    }

    @Override
    public void setProperties(Properties p) {
        double value = 0.9;
        try {
            String key = "crossover_probability";
            if (p.getProperty(key) != null && ((value = Double.parseDouble(p.getProperty(key))) < 0.0 || value > 1.0)) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            value = 0.9;
            System.out.println(e + " using default: " + value);
        }
        this.probability = value;
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rand = m;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rand;
    }
}

