/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.InitializationException;
import Mapper.GEGrammar;
import Mapper.Production;
import Mapper.Rule;
import Mapper.Symbol;
import Operator.Operations.GrowInitialiser;
import Util.Enums;
import Util.Random.RandomNumberGenerator;
import Util.Structures.NimbleTree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullInitialiser
extends GrowInitialiser {
    public FullInitialiser(RandomNumberGenerator rng, GEGrammar gegrammar, int maxDepth) {
        super(rng, gegrammar, maxDepth);
    }

    public FullInitialiser(RandomNumberGenerator rng, GEGrammar gegrammar, Properties p) {
        super(rng, gegrammar, p);
    }

    @Override
    public boolean grow(NimbleTree<Symbol> dt) {
        ArrayList<Integer> possibleRules = new ArrayList<Integer>();
        try {
            if (dt.getCurrentNode().getData().getType() == Enums.SymbolType.TSymbol) {
                if (dt.getCurrentNode().getData().getSymbolString().contains("BRR")) {
                    ++this.extraCodons;
                }
                return true;
            }
            if (dt.getCurrentLevel() > this.maxDepth) {
                System.out.println("Too deep:" + dt.getCurrentLevel() + ">" + this.maxDepth);
                return false;
            }
            Rule rule = this.grammar.findRule(dt.getCurrentNode().getData());
            if (rule != null) {
                int tmp;
                int diff;
                Production prod;
                Iterator prodIt = rule.iterator();
                possibleRules.clear();
                int ii = 0;
                boolean recursiveRules = false;
                while (prodIt.hasNext()) {
                    prod = (Production)prodIt.next();
                    if (dt.getCurrentLevel() + prod.getMinimumDepth() <= this.maxDepth) {
                        if (!recursiveRules && prod.getRecursive()) {
                            recursiveRules = true;
                            possibleRules.clear();
                        }
                        if (!recursiveRules || recursiveRules && prod.getRecursive()) {
                            possibleRules.add(ii);
                        }
                    }
                    ++ii;
                }
                if (possibleRules.isEmpty()) {
                    System.out.println("EmptyPossible rules:" + rule);
                    return false;
                }
                int prodVal = this.rng.nextInt(possibleRules.size());
                int modVal = (Integer)possibleRules.get(prodVal);
                int tmp1 = this.rng.nextInt(Integer.MAX_VALUE - rule.size());
                int mod = tmp1 % rule.size();
                if (mod > modVal) {
                    diff = mod - modVal;
                    tmp = tmp1 - diff;
                } else {
                    diff = modVal - mod;
                    tmp = tmp1 + diff;
                }
                int newMod = tmp % rule.size();
                if (newMod != modVal) {
                    System.out.println("modVal:" + modVal + " tmp1:" + tmp1 + " mod:" + mod + " tmp:" + tmp + " rule.size():" + rule.size() + " newMod:" + newMod);
                }
                if (rule.size() > 1) {
                    this.chromosome.add(tmp);
                    prod = (Production)rule.get((Integer)possibleRules.get(prodVal));
                } else {
                    prod = (Production)rule.get(0);
                }
                boolean result = true;
                int newMaxDepth = dt.getDepth();
                Iterator symIt = prod.iterator();
                while (symIt.hasNext() && result) {
                    Symbol symbol = (Symbol)symIt.next();
                    dt.addChild(symbol);
                    dt.setCurrentNode(dt.getCurrentNode().getEnd());
                    dt.setCurrentLevel(dt.getCurrentLevel() + 1);
                    result = this.grow(dt);
                    dt.setCurrentLevel(dt.getCurrentLevel() - 1);
                    if (newMaxDepth >= dt.getDepth()) continue;
                    newMaxDepth = dt.getDepth();
                }
                this.chromosome.setValid(result);
                dt.setDepth(newMaxDepth);
                return result;
            }
            if (!this.checkGECodonValue(dt)) {
                throw new InitializationException("Non-existent rule, maybe GECODON not yet impelemnted");
            }
            return true;
        }
        catch (InitializationException e) {
            e.printStackTrace();
            return false;
        }
    }
}

