/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.BadParameterException;
import Individuals.Individual;
import Operator.Operations.Operation;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MutationOperation
implements Stochastic,
Operation {
    protected double probability;
    protected RandomNumberGenerator rng;

    public MutationOperation(double prob, RandomNumberGenerator rng) {
        this.probability = prob;
        this.rng = rng;
    }

    public MutationOperation(RandomNumberGenerator rng, Properties p) {
        this.setProperties(p);
        this.rng = rng;
    }

    @Override
    public void setProperties(Properties p) {
        double value;
        try {
            String key = "mutation_probability";
            value = Double.parseDouble(p.getProperty(key));
            if (value < 0.0 || value > 1.0) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            value = 0.01;
            System.out.println(e + " using default: " + value);
        }
        this.probability = value;
    }

    @Override
    public abstract void doOperation(Individual var1);

    @Override
    public abstract void doOperation(List<Individual> var1);

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }
}

