/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.BadParameterException;
import Individuals.Chromosome;
import Individuals.FitnessPackage.BasicFitness;
import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.GEGrammar;
import Operator.Operations.CreationOperation;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomInitialiser
implements CreationOperation,
Stochastic {
    protected RandomNumberGenerator rng;
    protected GEGrammar grammar;
    protected int initChromSize;

    public RandomInitialiser(RandomNumberGenerator rng, GEGrammar g, int initChromSize) {
        this.rng = rng;
        this.grammar = g;
        this.initChromSize = initChromSize;
    }

    public RandomInitialiser(RandomNumberGenerator rng, GEGrammar g, Properties p) {
        this.rng = rng;
        this.grammar = g;
        this.setProperties(p);
    }

    @Override
    public void setProperties(Properties p) {
        int value;
        String std = "10";
        String key = "initial_chromosome_size";
        try {
            value = Integer.parseInt(p.getProperty(key, std));
            if (value < 1) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            value = Integer.parseInt(std);
            System.out.println(e + " for " + key + " using default: " + value);
        }
        this.initChromSize = value;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    @Override
    public void setRNG(RandomNumberGenerator rng) {
        this.rng = rng;
    }

    @Override
    public Individual createIndividual() {
        GEGrammar gram = new GEGrammar(this.grammar);
        Phenotype phenotype = new Phenotype();
        int[] codons = new int[this.initChromSize];
        GEChromosome chrom = new GEChromosome(this.initChromSize, codons);
        chrom.setMaxChromosomeLength(gram.getMaxChromosomeLengthByDepth());
        Genotype genotype = new Genotype(1, chrom);
        BasicFitness fitness = new BasicFitness();
        return new GEIndividual(gram, phenotype, genotype, fitness);
    }

    @Override
    public void doOperation(Individual operand) {
        int[] chr = new int[((Chromosome)operand.getGenotype().get(0)).getLength()];
        for (int i = 0; i < ((Chromosome)operand.getGenotype().get(0)).getLength(); ++i) {
            chr[i] = this.rng.nextInt(Integer.MAX_VALUE);
        }
        ((GEChromosome)operand.getGenotype().get(0)).setAll(chr);
    }

    @Override
    public void doOperation(List<Individual> operands) {
        for (Individual operand : operands) {
            this.doOperation(operand);
        }
    }
}

