/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.Individual;
import Individuals.Populations.Population;
import Individuals.Populations.SimplePopulation;
import Operator.Operations.Operation;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SelectionOperation
implements Operation {
    protected Population selectedPopulation;
    protected int size;

    public SelectionOperation(int size) {
        this.selectedPopulation = new SimplePopulation(size);
        this.size = size;
    }

    public SelectionOperation(Properties p) {
        this.setProperties(p);
    }

    public SelectionOperation() {
    }

    @Override
    public void setProperties(Properties p) {
        double valueD = 1.0;
        int valueI = Integer.parseInt("10");
        String key = "population_size";
        valueI = Integer.parseInt(p.getProperty(key, String.valueOf(valueI)));
        key = "replacement_type";
        if (p.getProperty(key) != null) {
            if (p.getProperty(key).equals("steady_state")) {
                valueD = 2.0 / (double)valueI;
            } else if (p.getProperty(key).equals("generational")) {
                valueD = 1.0;
            }
        } else {
            key = "selection_size";
            valueD = Double.parseDouble(p.getProperty(key, "1.0"));
        }
        this.size = (int)(valueD * (double)valueI);
        this.selectedPopulation = new SimplePopulation(this.size);
    }

    @Override
    public abstract void doOperation(Individual var1);

    @Override
    public abstract void doOperation(List<Individual> var1);

    public Population getSelectedPopulation() {
        return this.selectedPopulation;
    }

    public int getSize() {
        return this.size;
    }
}

