/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Populations.SimplePopulation;
import Mapper.GEGrammar;
import Operator.CrossoverModule;
import Operator.Operations.CrossoverOperation;
import Util.Random.MersenneTwisterFast;
import Util.Random.RandomNumberGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePointCrossover
extends CrossoverOperation {
    protected boolean fixedCrossoverPoint = true;

    public SinglePointCrossover(RandomNumberGenerator m, double prob) {
        super(prob, m);
    }

    public SinglePointCrossover(RandomNumberGenerator m, Properties p) {
        super(m, p);
        this.setProperties(p);
    }

    @Override
    public void setProperties(Properties p) {
        super.setProperties(p);
        boolean b = false;
        try {
            String key = "fixed_point_crossover";
            String value = p.getProperty(key);
            if (value != null && value.equals("true")) {
                b = true;
            }
        }
        catch (Exception e) {
            System.out.println(e + " using default: " + b);
        }
        this.fixedCrossoverPoint = b;
    }

    @Override
    public void doOperation(Individual operands) {
    }

    @Override
    public void doOperation(List<Individual> operands) {
        if (this.rand.nextDouble() < this.probability) {
            GEIndividual p1 = (GEIndividual)operands.get(0);
            GEIndividual p2 = (GEIndividual)operands.get(1);
            GEChromosome chrom1 = (GEChromosome)p1.getGenotype().get(0);
            GEChromosome chrom2 = (GEChromosome)p2.getGenotype().get(0);
            if (this.rand.nextBoolean()) {
                this.makeNewChromosome(chrom1, chrom2);
            } else {
                this.makeNewChromosome(chrom2, chrom1);
            }
        }
    }

    private int getXoverPoint(int l1, int l2) {
        if (l1 < l2) {
            return this.rand.nextInt() % l1;
        }
        return this.rand.nextInt() % l2;
    }

    public void makeNewChromosome(GEChromosome c1, GEChromosome c2) {
        if (this.fixedCrossoverPoint) {
            int point1 = this.getXoverPoint(c1.size(), c2.size());
            for (int i = 0; i < point1; ++i) {
                int tmp1 = c1.get(i);
                int tmp2 = c2.get(i);
                c1.set(i, tmp2);
                c2.set(i, tmp1);
            }
        } else {
            int i;
            int point1 = this.rand.nextInt(c1.size());
            int point2 = this.rand.nextInt(c2.size());
            int[] tmp1 = c1.toArray();
            int[] tmp2 = c2.toArray();
            c1.clear();
            c2.clear();
            for (i = 0; i < point1; ++i) {
                c1.add(tmp1[i]);
            }
            for (i = point2; i < tmp2.length; ++i) {
                c1.add(tmp2[i]);
            }
            for (i = 0; i < point2; ++i) {
                c2.add(tmp2[i]);
            }
            for (i = point1; i < tmp1.length; ++i) {
                c2.add(tmp1[i]);
            }
        }
    }

    public boolean isFixedCrossoverPoint() {
        return this.fixedCrossoverPoint;
    }

    public void setFixedCrossoverPoint(boolean fixedCrossoverPoint) {
        this.fixedCrossoverPoint = fixedCrossoverPoint;
    }

    public static void main(String[] args) {
        SinglePointCrossover cop = new SinglePointCrossover((RandomNumberGenerator)new MersenneTwisterFast(), 1.0);
        cop.setFixedCrossoverPoint(false);
        GEChromosome c1 = new GEChromosome(10);
        GEChromosome c2 = new GEChromosome(10);
        for (int i = 0; i < 20; ++i) {
            c1.add(1);
            c2.add(2);
        }
        cop.makeNewChromosome(c1, c2);
        System.out.println(c1.toString());
        System.out.println(c2.toString());
        Genotype g1 = new Genotype();
        Genotype g2 = new Genotype();
        g1.add(c1);
        g2.add(c2);
        GEIndividual i1 = new GEIndividual();
        GEIndividual i2 = new GEIndividual();
        i1.setMapper(new GEGrammar());
        i1.setGenotype(g1);
        i2.setMapper(new GEGrammar());
        i2.setGenotype(g2);
        ArrayList<Individual> aI = new ArrayList<Individual>(2);
        aI.add(i1);
        aI.add(i2);
        cop.doOperation(aI);
        System.out.println();
        System.out.println("Testing operation crossover");
        System.out.println();
        c1 = (GEChromosome)i1.getGenotype().get(0);
        c2 = (GEChromosome)i2.getGenotype().get(0);
        System.out.println(c1.toString());
        System.out.println(c2.toString());
        CrossoverModule cm = new CrossoverModule(new MersenneTwisterFast(), cop);
        SimplePopulation p = new SimplePopulation();
        p.add(i1);
        p.add(i2);
        cm.setPopulation(p);
        long st = System.currentTimeMillis();
        for (int i = 1; i < 100000000; i += 20) {
            cm.perform();
        }
        long et = System.currentTimeMillis();
        System.out.println("Done running: Total time(Ms) for 100000000 generations was" + (et - st));
        System.out.println();
        System.out.println("Testing module crossover");
        System.out.println();
        c1 = (GEChromosome)i1.getGenotype().get(0);
        c2 = (GEChromosome)i2.getGenotype().get(0);
        System.out.println(c1.toString());
        System.out.println(c2.toString());
    }
}

