/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.Individual;
import Operator.Operations.Operation;
import Operator.Operations.OutputI;
import Util.Statistics.IndividualCatcher;
import Util.Statistics.StatCatcher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsCollectionOperation
implements Operation,
OutputI {
    protected StatCatcher stats;
    protected IndividualCatcher indCatch;
    protected String fileName;
    private static final String OUTPUT_COLUMNS = "#bestFitness averageFitness averageUsedGeneLength time invalids varFitness aveLength aveDerivationTreeDepth";
    private static final String OUTPUT_COLUMNS_STDOUT = "Gen\tFitEvals\tTime(ms)\tInvalids\tBestFit\tAveFit\tVarFit\tAveUsedGenes\tAveLength\tAveDTDepth";

    public StatisticsCollectionOperation(StatCatcher stats, IndividualCatcher indCatch) {
        this.stats = stats;
        this.indCatch = indCatch;
    }

    public StatisticsCollectionOperation(StatCatcher stats, IndividualCatcher indCatch, Properties p) {
        this.stats = stats;
        this.indCatch = indCatch;
        this.setProperties(p);
    }

    public void printHeader() {
        System.out.println("#---Data---");
        System.out.println(OUTPUT_COLUMNS_STDOUT);
    }

    public void printStatsistics(long time) {
        System.out.format("%1$4d\t%9$5d\t%2$6d\t%3$4d\t%4$6.3f\t%5$6.3f\t%6$8.3f\t%7$6.3f\t%8$6.3f\t%10$6.3f%n", this.stats.getInvalids().size() - 1, time, this.stats.getInvalids().get(this.stats.getInvalids().size() - 1), this.stats.getCurrentBestFitness(), this.stats.getCurrentMean(), this.stats.getVarFitness().get(this.stats.getVarFitness().size() - 1), this.stats.getCurrentMeanUsedGenes(), this.stats.getAveLength().get(this.stats.getAveLength().size() - 1), 0, this.stats.getMeanDerivationTreeDepth().get(this.stats.getMeanDerivationTreeDepth().size() - 1));
    }

    @Override
    public void setProperties(Properties p) {
        String value = System.getProperty("user.dir");
        try {
            String key = "output";
            String tmp = p.getProperty(key);
            if (tmp != null) {
                if (tmp.equals("false")) {
                    value = "";
                } else {
                    if (!tmp.startsWith(System.getProperty("file.separator"))) {
                        value = value + System.getProperty("file.separator");
                    }
                    value = value + tmp;
                    File f = new File(value);
                    if (value.endsWith(System.getProperty("file.separator")) && !f.isDirectory()) {
                        throw new FileNotFoundException(value);
                    }
                    System.out.println("Output directory is " + value);
                }
            } else {
                value = "";
            }
        }
        catch (Exception e) {
            value = System.getProperty("user.dir") + System.getProperty("file.separator");
            System.out.println("Using default output directory: " + value);
        }
        this.fileName = value;
    }

    @Override
    public void doOperation(Individual operand) {
    }

    @Override
    public void doOperation(List<Individual> operands) {
        Long start = System.currentTimeMillis();
        this.stats.addTime(start);
        this.stats.addStatsPop((ArrayList)operands);
        if (this.indCatch.getCatchInterval() < Integer.MAX_VALUE) {
            this.catchIndividuals(operands);
        }
    }

    private void catchIndividuals(List<Individual> operands) {
        ArrayList<Individual> alI = new ArrayList<Individual>(operands.size() / this.indCatch.getCatchInterval());
        Iterator<Individual> ind_it = operands.iterator();
        int cnt = 1;
        while (ind_it.hasNext()) {
            Individual ind = ind_it.next();
            if (cnt % this.indCatch.getCatchInterval() == 0) {
                alI.add(ind);
            }
            ++cnt;
        }
        this.indCatch.addPop(alI);
        this.indCatch.addString(System.getProperty("line.separator"));
        if (this.indCatch.getCapacity() > 10000000) {
            System.out.println(this.indCatch.getCapacity());
            this.printIndividuals("tmpInd_ind_.dat", true);
            this.indCatch.clear();
        }
    }

    private void printIndividuals(String fileName, boolean append) {
        try {
            FileWriter fw = new FileWriter(fileName, append);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(this.indCatch.toString());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public StatCatcher getStats() {
        return this.stats;
    }

    public IndividualCatcher getIndividualCatcher() {
        return this.indCatch;
    }

    @Override
    public void print(List<Individual> operand, boolean toFile) {
        if (toFile) {
            this.printStats();
        }
        this.indCatch.addPop(operand);
        System.out.println(this.indCatch);
    }

    private void printIndividuals() {
        try {
            FileWriter fw = new FileWriter(this.fileName + "_ind_.dat");
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(this.indCatch.toString());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printStats() {
        try {
            this.fileName = this.fileName + System.currentTimeMillis();
            FileWriter fw = new FileWriter(this.fileName + ".dat");
            BufferedWriter bw = new BufferedWriter(fw);
            ArrayList<Double> b = this.stats.getBestFitness();
            ArrayList<Double> m = this.stats.getMeanFitness();
            ArrayList<Double> aUG = this.stats.getMeanUsedGenes();
            ArrayList<Long> t = this.stats.getTime();
            ArrayList<Integer> inv = this.stats.getInvalids();
            ArrayList<Double> aV = this.stats.getVarFitness();
            ArrayList<Double> aL = this.stats.getAveLength();
            ArrayList<Double> aD = this.stats.getMeanDerivationTreeDepth();
            Iterator<Double> ib = b.iterator();
            Iterator<Double> im = m.iterator();
            Iterator<Double> iAV = aV.iterator();
            Iterator<Double> iAUG = aUG.iterator();
            Iterator<Double> iAD = aD.iterator();
            Iterator<Long> iT = t.iterator();
            Iterator<Integer> iInv = inv.iterator();
            Iterator<Double> iAL = aL.iterator();
            Long start = iT.next();
            bw.write(OUTPUT_COLUMNS);
            bw.newLine();
            while (ib.hasNext() && im.hasNext() && iAUG.hasNext() && iT.hasNext() && iInv.hasNext() && iAV.hasNext() && iAL.hasNext() && iAD.hasNext()) {
                Long stop = iT.next();
                Long diff = stop - start;
                start = stop;
                bw.write(ib.next() + " " + im.next() + " " + iAUG.next() + " " + diff + " " + iInv.next() + " " + iAV.next() + " " + iAL.next() + " " + iAD.next());
                bw.newLine();
            }
            bw.close();
            fw.close();
            m.clear();
            b.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

