/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Util.GEVAHelper;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileNameExtensionFilter
extends FileFilter {
    private String description;
    private String[] extensions;

    public FileNameExtensionFilter(String description, String ... extensions) {
        this.description = description;
        this.extensions = GEVAHelper.trim(extensions);
        this.undotExtensions();
    }

    private void undotExtensions() {
        for (int i = 0; i < this.extensions.length; ++i) {
            if (this.extensions[i].length() <= 1 || this.extensions[i].charAt(0) != '.') continue;
            this.extensions[i] = this.extensions[i].substring(1);
        }
    }

    public boolean accept(File f) {
        if (this.extensions == null) {
            return true;
        }
        if (f.isDirectory()) {
            return true;
        }
        String fileExtension = f.getName();
        int dot = fileExtension.lastIndexOf(46) + 1;
        if (dot == 0) {
            return false;
        }
        fileExtension = fileExtension.substring(dot);
        for (String extension : this.extensions) {
            if (extension.length() != 0 && !extension.equals(fileExtension)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        StringBuilder extensionList = null;
        if (this.extensions != null) {
            for (String extension : this.extensions) {
                if (extension.trim().length() == 0) continue;
                if (extensionList == null) {
                    extensionList = new StringBuilder();
                    extensionList.append(extension);
                    continue;
                }
                extensionList.append("|" + extension);
            }
        }
        if (extensionList != null) {
            extensionList.insert(0, " (");
            extensionList.append(')');
            return this.description + extensionList.toString();
        }
        return this.description;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public String toString() {
        if (this.extensions != null) {
            return this.extensions[0];
        }
        return null;
    }
}

