/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class PathTools {
    private PathTools() {
    }

    public static String getAbsolutePath(String relativePath) {
        return PathTools.getAbsolutePath(relativePath, null, true);
    }

    public static String getAbsolutePath(String relativePath, String workingPath) {
        return PathTools.getAbsolutePath(relativePath, workingPath, true);
    }

    public static String getAbsolutePath(String relativePath, boolean addSlash) {
        return PathTools.getAbsolutePath(relativePath, null, addSlash);
    }

    public static String getAbsolutePath(String relativePath, String workingPath, boolean addSlash) {
        String path;
        if (relativePath == null) {
            return null;
        }
        File file = new File(relativePath);
        if (!file.isAbsolute()) {
            file = new File(workingPath, relativePath);
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                path = file.getAbsolutePath();
            }
        } else {
            path = relativePath;
        }
        if (addSlash && file.isDirectory()) {
            path = PathTools.getSafePath(path);
        }
        return path.replace("\\", "/");
    }

    private static PathList getPathList(String relativePath, String workingPath) {
        PathList pathList = new PathList();
        File relativeFile = new File(relativePath);
        try {
            for (File pathParser = workingPath == null || relativeFile.isAbsolute() ? relativeFile.getCanonicalFile() : new File(workingPath, relativePath).getCanonicalFile(); pathParser != null; pathParser = pathParser.getParentFile()) {
                if (pathParser.getName().length() != 0) {
                    pathList.add(pathParser.getName());
                    continue;
                }
                pathList.add(pathParser.getPath());
            }
        }
        catch (IOException e) {
            System.err.format("relativePath [%s] workingPath [%s]%n", relativePath, workingPath);
            e.printStackTrace();
            pathList = null;
        }
        return pathList;
    }

    private static String parsePathLists(PathList workingPath, PathList absolutePath) {
        int j;
        StringBuilder relativePath = new StringBuilder();
        int i = workingPath.size() - 1;
        for (j = absolutePath.size() - 1; i >= 0 && j >= 0 && ((String)workingPath.get(i)).equals(absolutePath.get(j)); --i, --j) {
        }
        while (i >= 0) {
            relativePath.append(".." + File.separator);
            --i;
        }
        while (j >= 0) {
            if (j > 0) {
                relativePath.append((String)absolutePath.get(j) + File.separator);
            } else {
                relativePath.append((String)absolutePath.get(j));
            }
            --j;
        }
        return relativePath.toString();
    }

    public static String getRelativePath(String absolutePath) {
        return PathTools.getRelativePath(absolutePath, null, true);
    }

    public static String getRelativePath(String absolutePath, boolean addSlash) {
        return PathTools.getRelativePath(absolutePath, null, addSlash);
    }

    public static String getRelativePath(String absolutePath, String workingPath) {
        return PathTools.getRelativePath(absolutePath, workingPath, true);
    }

    public static String getRelativePath(String absolutePath, String workingPath, boolean addSlash) {
        if (workingPath == null) {
            workingPath = PathTools.getAbsolutePath(".");
        }
        absolutePath = absolutePath.trim();
        workingPath = workingPath.trim();
        String path = PathTools.parsePathLists(PathTools.getPathList(workingPath, null), PathTools.getPathList(absolutePath, workingPath));
        if (addSlash && new File(PathTools.getAbsolutePath(path, workingPath)).isDirectory()) {
            path = PathTools.getSafePath(path);
        }
        return path.replace("\\", "/");
    }

    public static String getSafePath(String path) {
        if (path == null || path.length() == 0) {
            return "./";
        }
        if (path.charAt(path.length() - 1) != '/' && path.charAt(path.length() - 1) != '\\') {
            path = path + "/";
        }
        return path;
    }

    public static String[] fileList(String pathList) {
        String[] paths;
        PathList files = new PathList();
        for (String path : paths = pathList.split(";")) {
            PathTools.fileList("", null, path.split("/"), 0, files, null, 0);
        }
        return files.toArray(new String[files.size()]);
    }

    private static void fileList(String base, String folder, String[] folders, int index, PathList files, String wildcard, int repeat) {
        if (folder == null) {
            folder = folders[index];
        }
        base = base + folder + "/";
        ++index;
        if (repeat > 0 && repeat < Integer.MAX_VALUE) {
            --repeat;
        }
        File file = new File(base);
        String[] results = file.list();
        int colon = folders[index].indexOf(58);
        int localRepeat = 0;
        if (colon != -1) {
            try {
                String parseRepeat = folders[index].substring(0, colon);
                localRepeat = parseRepeat.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(parseRepeat);
                folders[index] = folders[index].substring(colon + 1);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (results != null) {
            if (index < folders.length - 1) {
                for (String result : results) {
                    if (!result.matches(folders[index])) continue;
                    PathTools.fileList(base, result, folders, index, files, folders[index], localRepeat);
                }
            } else {
                for (String result : results) {
                    if (!result.matches(folders[index])) continue;
                    files.add(base + result);
                }
            }
        }
        if (results != null && repeat > 0) {
            for (String result : results) {
                if (!result.matches(wildcard)) continue;
                PathTools.fileList(base, result, folders, index - 1, files, wildcard, repeat);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathList
    extends ArrayList<String> {
        private PathList() {
        }
    }
}

