/*
 * Decompiled with CFR 0.152.
 */
package Util.Statistics;

import Exceptions.BadParameterException;
import Individuals.FitnessPackage.Fitness;
import Individuals.Individual;
import Parameter.ParameterI;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndividualCatcher
implements ParameterI {
    private StringBuffer sb = new StringBuffer();
    private int catchInterval;

    public IndividualCatcher() {
        this.catchInterval = 10;
    }

    public IndividualCatcher(Properties p) {
        this.setProperties(p);
    }

    @Override
    public void setProperties(Properties p) {
        int valueI;
        try {
            String key = "individual_catch_interval";
            valueI = Integer.parseInt(p.getProperty(key));
            if (valueI < 1) {
                if (valueI != -1) {
                    throw new BadParameterException(key);
                }
                valueI = Integer.MAX_VALUE;
            }
        }
        catch (Exception e) {
            valueI = Integer.MAX_VALUE;
            System.out.println("Catch interval default: best individual");
        }
        this.catchInterval = valueI;
    }

    public void addPop(List<Individual> population) {
        Object[] fA = new Fitness[population.size()];
        for (int i = 0; i < fA.length; ++i) {
            fA[i] = population.get(i).getFitness();
        }
        Arrays.sort(fA);
        for (int cnt = 0; cnt < fA.length; cnt += this.catchInterval) {
            this.sb.append("Rank:").append(cnt).append(" Fit:").append(fA[cnt].getDouble());
            this.sb.append(" Phenotype:").append(fA[cnt].getIndividual().toString());
            this.sb.append(System.getProperty("line.separator"));
        }
    }

    public void addString(String s) {
        this.sb.append(s);
    }

    public void clear() {
        this.sb = new StringBuffer();
    }

    public int getCapacity() {
        return this.sb.capacity();
    }

    public void setCatchInterval(int catchInterval) {
        this.catchInterval = catchInterval;
    }

    public int getCatchInterval() {
        return this.catchInterval;
    }

    public String toString() {
        return this.sb.toString();
    }
}

