/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.main;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jeco.dmm.DMMFitness;
import jeco.dmm.simulator.DMMCreator;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.layers.AbstractHeap;

public class DMMSimulator {
    private static Logger logger = Logger.getLogger(DMMSimulator.class.getName());
    protected AbstractHeap heap;
    protected long sizeOfMemoryInKB;
    protected String pathToProfile;
    protected String pathToResults;

    public DMMSimulator(AbstractHeap heap, long sizeOfMemoryInKB, String pathToProfile, String pathToResults) {
        this.heap = heap;
        this.sizeOfMemoryInKB = sizeOfMemoryInKB;
        this.pathToProfile = pathToProfile;
        this.pathToResults = pathToResults;
    }

    public double[] run() {
        double[] fitness = new double[5];
        Properties properties = new Properties();
        properties.setProperty("profile_path", this.pathToProfile);
        properties.setProperty("accesses_path", this.pathToResults);
        DMMFitness fitFunction = new DMMFitness();
        fitFunction.setProperties(properties);
        double startTime = System.currentTimeMillis();
        fitFunction.simulate(this.heap);
        double endTime = System.currentTimeMillis();
        double totalTime = (endTime - startTime) / 1000.0;
        logger.info("Collecting statistics and creating accesses files...\n");
        fitness[0] = DMMLogger.getExecutionTimeReal() + DMMLogger.getMemoryUsedInHeap() + DMMLogger.getMemUsedByDMMSupport() + DMMLogger.getMemoryAccessesReal();
        fitness[1] = DMMLogger.getExecutionTimeReal();
        fitness[2] = DMMLogger.getMemoryUsedInHeap() + DMMLogger.getMemUsedByDMMSupport();
        fitness[3] = DMMLogger.getMemoryAccessesReal();
        fitness[4] = totalTime;
        return fitness;
    }

    public static void main(String[] args) {
        LogManager.getLogManager().getLogger("").setLevel(Level.INFO);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(Level.INFO);
        }
        if (args.length != 4) {
            long memory = (long)(128.0 * Math.pow(2.0, 10.0));
            args = new String[]{"KINGSLEY", String.valueOf(memory), "test/Binaries/vdriftx2r0.mem", "test/Binaries/vdriftx2r0_kingsley.out"};
            System.out.println("Usage:");
            System.out.println("DMMSimulator <KINGSLEY|LEA|CUSTOM> <SizeOfMemoryInKB> <PathToProfile> <PathToResults>");
            System.out.println("Example: DMMSimulator KINGSLEY 131072 test.mem test.mem.out");
            System.out.println("where:");
            System.out.println("KINGSLEY: Evaluates the application using the KINGSLEY DMM");
            System.out.println("LEA: Evaluates the application using the DOUG LEA DMM");
            System.out.println("CUSTOM: Evaluates the application using a custom DMM");
            System.out.println("<SizeOfMemoryInKB>: Memory size (in KB)");
            System.out.println("<PathToProfile>: Relative path to the profiling report");
            System.out.println("<PathToResults>: Relative path to the output file");
            return;
        }
        String dmmAsString = args[0];
        long sizeOfMemoryInKB = Long.valueOf(args[1]);
        String pathToProfile = args[2];
        String pathToResults = args[3];
        DMMSimulator simulator = null;
        if (dmmAsString.equals("KINGSLEY")) {
            simulator = new DMMSimulator(DMMCreator.buildKingsleyHeap(sizeOfMemoryInKB), sizeOfMemoryInKB, pathToProfile, pathToResults);
        } else if (dmmAsString.equals("LEA")) {
            simulator = new DMMSimulator(DMMCreator.buildLea2_7Heap(sizeOfMemoryInKB), sizeOfMemoryInKB, pathToProfile, pathToResults);
        } else {
            String[] parts = dmmAsString.split(":");
            ArrayList<String> symbols = new ArrayList<String>();
            for (int i = 0; i < parts.length; ++i) {
                symbols.add(parts[i]);
            }
            try {
                simulator = new DMMSimulator(DMMCreator.buildCustomAllocator(symbols), sizeOfMemoryInKB, pathToProfile, pathToResults);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        double[] fitness = simulator.run();
        logger.info("Main objective = " + fitness[0]);
        logger.info("Execution time = " + fitness[1]);
        logger.info("Memory usage = " + fitness[2]);
        logger.info("Energy consumed = " + fitness[3]);
        logger.info("Simulation time = " + fitness[4]);
    }
}

