/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.Fitness;
import jeco.dmm.sim2.lib.Simulator;
import jeco.dmm.sim2.lib.allocator.BuddySystem;
import jeco.dmm.sim2.lib.allocator.ExactSegregatedFit;
import jeco.dmm.sim2.lib.allocator.Kingsley;
import jeco.dmm.sim2.lib.allocator.Lea;
import jeco.dmm.sim2.lib.allocator.SegregatedFreeList;
import jeco.dmm.sim2.lib.freelist.FreeList;
import jeco.dmm.sim2.util.ManagersCreator;
import jeco.dmm.sim2.util.ProfilingReport;
import jeco.kernel.algorithm.ge.GrammaticalEvolutionaryAlgorithm;
import jeco.kernel.util.LoggerFormatter;

public class DmmExplorer {
    public static final String DMM_KINGSLEY = "KINGSLEY";
    public static final String DMM_LEA = "LEA";
    public static final String DMM_FIBONACCI = "FIBONACCI";
    public static final String DMM_SEGREGATED = "SEGREGATED";
    public static final String DMM_EXACT = "EXACT";
    public static final String DMM_GE = "GE";
    protected String profilePath = null;
    protected String baseName = null;
    protected String grammarPath = null;
    protected String mtrPath = null;
    protected String mapPath = null;
    protected ProfilingReport profilingReport = null;
    protected DynamicMemoryManager manager = null;

    public DmmExplorer(String profilePath) {
        this.profilePath = profilePath;
        int pos = profilePath.lastIndexOf(".mem");
        this.baseName = profilePath.substring(0, pos);
        this.grammarPath = String.valueOf(this.baseName) + ".bnf";
    }

    public void readProfile() throws InterruptedException {
        this.profilingReport = new ProfilingReport(this.profilePath);
        this.profilingReport.start();
        this.profilingReport.join();
    }

    public void configure(String dmmSelected) {
        this.mtrPath = String.valueOf(this.baseName) + "." + dmmSelected + ".mtr";
        this.mapPath = String.valueOf(this.baseName) + "." + dmmSelected + ".map";
        if (dmmSelected.equals(DMM_KINGSLEY)) {
            this.manager = new DynamicMemoryManager(new Kingsley());
        } else if (dmmSelected.equals(DMM_LEA)) {
            this.manager = new Lea(this.profilingReport);
        } else if (dmmSelected.equals(DMM_FIBONACCI)) {
            BuddySystem fibonacci = new BuddySystem(BuddySystem.TYPE.FIBONACCI, 0L, this.profilingReport.getMaxSizeInB(), false, false);
            fibonacci.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            this.manager = new DynamicMemoryManager(fibonacci);
        } else if (dmmSelected.equals(DMM_SEGREGATED)) {
            SegregatedFreeList segregated = new SegregatedFreeList(0L, this.profilingReport.getMaxSizeInB(), false, false);
            ManagersCreator.buildSeveralFreeLists(10, segregated, FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            this.manager = new DynamicMemoryManager(segregated);
        } else if (dmmSelected.equals(DMM_EXACT)) {
            ExactSegregatedFit exact = new ExactSegregatedFit(0L, this.profilingReport.getMaxSizeInB(), this.profilingReport.getSizesInB());
            exact.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            this.manager = new DynamicMemoryManager(exact);
        }
    }

    public void setLevel(Level level) {
        try {
            FileHandler fh = new FileHandler(String.valueOf(DmmExplorer.class.getSimpleName()) + ".txt", false);
            Logger.getLogger("").addHandler(fh);
        }
        catch (IOException ex) {
            Logger.getLogger(DmmExplorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(DmmExplorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        Handler[] handlers = Logger.getLogger("").getHandlers();
        int index = 0;
        while (index < handlers.length) {
            handlers[index].setLevel(level);
            handlers[index].setFormatter(LoggerFormatter.formatter);
            ++index;
        }
    }

    public void runPredefinedDmm() throws InterruptedException, IOException {
        Logger.getLogger(this.getClass().getName()).info("Min size: " + this.profilingReport.getMinSizeInB() + "B");
        Logger.getLogger(this.getClass().getName()).info("Max size: " + this.profilingReport.getMaxSizeInB() + "B");
        Simulator simulator = new Simulator(this.profilingReport, this.manager);
        simulator.start();
        simulator.join();
        String mapAsString = simulator.drawAllocatorMap();
        String reportAsString = simulator.getMetrics().report();
        Logger.getLogger(this.getClass().getName()).info(mapAsString);
        Logger.getLogger(this.getClass().getName()).info(reportAsString);
        BufferedWriter writer = null;
        Logger.getLogger(this.getClass().getName()).info("Saving map ...");
        writer = new BufferedWriter(new FileWriter(new File(this.mapPath)));
        writer.write(mapAsString);
        writer.flush();
        writer.close();
        Logger.getLogger(this.getClass().getName()).info("Saving metrics ...");
        writer = new BufferedWriter(new FileWriter(new File(this.mtrPath)));
        writer.write(reportAsString);
        writer.flush();
        writer.close();
        Logger.getLogger(this.getClass().getName()).info("DONE.");
    }

    public void runGramEvo(String numberOfGen, String numberOfInd, double globalOptimum) {
        Fitness.globalOptimum = globalOptimum;
        Fitness.evaluated.clear();
        Fitness.profilingReport = this.profilingReport;
        GrammaticalEvolutionaryAlgorithm optimizer = new GrammaticalEvolutionaryAlgorithm(this.grammarPath, Fitness.class.getName());
        optimizer.setProperty("stopWhenSolved", "true");
        optimizer.setProperty("generations", numberOfGen);
        optimizer.setProperty("population_size", numberOfInd);
        optimizer.setProperty("max_depth", "10");
        optimizer.setProperty("mutation_probability", "0.02");
        optimizer.setProperty("crossover_probability", "0.8");
        Logger.getLogger(this.getClass().getName()).info("Initializing gramatical evolution...\n");
        optimizer.initialize();
        Logger.getLogger(this.getClass().getName()).info("Executing gramatical evolution...\n");
        optimizer.execute();
        Logger.getLogger(this.getClass().getName()).info("done.\n");
        this.manager = ManagersCreator.buildManagerFromPhenotype(this.profilingReport, optimizer.getBestFitness().getIndividual().getPhenotype());
    }

    public static void printHelp() {
        System.out.println("Usage:");
        System.out.println("java -jar " + DmmExplorer.class.getSimpleName() + ".jar -p <PathToProfilingReport> [-d <KINGSLEY,LEA,FIBONACCI,SEGREGATED,EXACT,GE> (default: KINGSLEY)] [-g <NumberOfGenerations> (default: 100)] [-i <NumberOfIndividuals> (default: 60)] [-o <GlobalOptimum>]");
        System.out.println("java -jar " + DmmExplorer.class.getSimpleName() + ".jar -p boxed-sim.mem -d LEA,GE -g 80 -i 30");
        System.out.println("where:");
        System.out.println("-p <ProfilingReport>: Relative path to the profiling report including malloc/free entries");
        System.out.println("-d <KINGSLEY,LEA,FIBONACCI,SEGREGATED,EXACT,GE>: Is the DMM simulator selected. GE will find a custom DMM using Grammatical evolution )(a .bnf file is needed in the same path that the profiling report).");
        System.out.println("-g <NumberOfGenerations>: Number of generations for GE (default is 100)");
        System.out.println("-i <NumberOfIndividuals>: Number of individuals for GE (default is 60)");
        System.out.println("-o <GlobalOptimum>: GE stops when GlobalOptimum is reached (default is 0.0)");
    }

    public static void main(String[] args) {
        String profilePath = null;
        String numberOfGen = null;
        String numberOfInd = null;
        Double globalOptim = null;
        ArrayList<String> dmmsSelected = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-p")) {
                profilePath = args[i + 1];
            } else if (args[i].equals("-d")) {
                String[] parts = args[i + 1].split(",");
                int j = 0;
                while (j < parts.length) {
                    dmmsSelected.add(parts[j]);
                    ++j;
                }
            } else if (args[i].equals("-g")) {
                numberOfGen = args[i + 1];
            } else if (args[i].equals("-i")) {
                numberOfInd = args[i + 1];
            } else if (args[i].equals("-o")) {
                globalOptim = Double.valueOf(args[i + 1]);
            }
            i += 2;
        }
        if (profilePath == null) {
            DmmExplorer.printHelp();
            return;
        }
        if (globalOptim == null) {
            globalOptim = 0.0;
        }
        if (dmmsSelected.size() == 0) {
            dmmsSelected.add(DMM_KINGSLEY);
        }
        if (numberOfGen == null) {
            numberOfGen = "100";
        }
        if (numberOfInd == null) {
            numberOfInd = "60";
        }
        DmmExplorer dmmOptimizer = new DmmExplorer(profilePath);
        dmmOptimizer.setLevel(Level.INFO);
        try {
            dmmOptimizer.readProfile();
            for (String dmmSelected : dmmsSelected) {
                Logger.getLogger(DmmExplorer.class.getName()).info("Running DMM: " + dmmSelected + " ...");
                if (!(dmmSelected.equals(DMM_KINGSLEY) || dmmSelected.equals(DMM_LEA) || dmmSelected.equals(DMM_FIBONACCI) || dmmSelected.equals(DMM_SEGREGATED) || dmmSelected.equals(DMM_EXACT) || dmmSelected.equals(DMM_GE))) {
                    Logger.getLogger(DmmExplorer.class.getName()).info("... DMM " + dmmSelected + " not allowed yet.");
                    continue;
                }
                dmmOptimizer.configure(dmmSelected);
                if (dmmSelected.equals(DMM_GE)) {
                    dmmOptimizer.runGramEvo(numberOfGen, numberOfInd, globalOptim);
                }
                dmmOptimizer.runPredefinedDmm();
                Logger.getLogger(DmmExplorer.class.getName()).info("... done.");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DmmExplorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DmmExplorer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

