/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jeco.kernel.util.LoggerFormatter;

public class Repair {
    private static Logger logger = Logger.getLogger(Repair.class.getName());
    protected long currentObjectId = 1L;
    protected String pathToOriginalProfile;
    protected String pathToNewProfile;
    protected LinkedList<String> originalProfile;
    protected LinkedList<String> newProfile;

    public Repair(String pathToOriginalProfile, String pathToNewProfile) {
        this.pathToOriginalProfile = pathToOriginalProfile;
        this.pathToNewProfile = pathToNewProfile;
        this.originalProfile = new LinkedList();
        this.newProfile = new LinkedList();
    }

    protected void loadLists() throws Exception {
        logger.fine("Loading the content of the profiling report ...");
        BufferedReader reader = new BufferedReader(new FileReader(new File(this.pathToOriginalProfile)));
        String newLine = null;
        String line = reader.readLine();
        while (line != null) {
            newLine = line.replaceAll("new ", "new -");
            newLine = newLine.replaceAll("delete ", "delete -");
            newLine = newLine.replaceAll("read ", "read -");
            newLine = newLine.replaceAll("write ", "write -");
            this.originalProfile.add(newLine);
            line = reader.readLine();
        }
        reader.close();
        logger.fine("done.");
    }

    protected void fix() {
        logger.fine("Fixing the original profile ...");
        String currentOperation = null;
        String[] parts = null;
        String oldObjectId = null;
        String newObjectId = null;
        long profileSize = this.originalProfile.size();
        long currentIndex = 0L;
        long nextPercentageReport = 10L;
        while (!this.originalProfile.isEmpty()) {
            long percentage;
            currentOperation = this.originalProfile.remove();
            if ((percentage = (long)Math.round(++currentIndex * 100L / profileSize)) == nextPercentageReport) {
                logger.fine(percentage + "% success ...");
                nextPercentageReport += 10L;
            }
            if ((parts = currentOperation.split(" "))[1].equals("new") && parts[2].startsWith("-")) {
                oldObjectId = parts[2];
                newObjectId = String.valueOf(this.currentObjectId++);
                currentOperation = currentOperation.replaceAll("new " + oldObjectId, "new " + newObjectId);
                this.fixThisObject(oldObjectId, newObjectId);
            }
            this.newProfile.add(currentOperation);
        }
        logger.fine("done.");
    }

    protected void save() throws Exception {
        logger.fine("Saving new profile ...");
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.pathToNewProfile)));
        String currentOperation = null;
        while (!this.newProfile.isEmpty()) {
            currentOperation = this.newProfile.remove();
            writer.write(currentOperation + "\n");
        }
        writer.flush();
        writer.close();
        logger.fine("done.");
    }

    protected void addTime() throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.pathToNewProfile)));
        BufferedReader reader = new BufferedReader(new FileReader(new File(this.pathToOriginalProfile)));
        long lineNumber = 0L;
        String line = reader.readLine();
        String newLine = null;
        while (line != null) {
            newLine = ++lineNumber + " " + line + "\n";
            writer.write(newLine);
            line = reader.readLine();
        }
        reader.close();
        writer.flush();
        writer.close();
    }

    private void fixThisObject(String oldObjectId, String newObjectId) {
        ListIterator<String> itr = this.originalProfile.listIterator();
        String currentOperation = null;
        String[] patterns = new String[]{"new " + oldObjectId, "delete " + oldObjectId, "read " + oldObjectId, "write " + oldObjectId};
        String[] replacements = new String[]{"new " + newObjectId, "delete " + newObjectId, "read " + newObjectId, "write " + newObjectId};
        while (itr.hasNext()) {
            currentOperation = (String)itr.next();
            for (int i = 0; i < patterns.length; ++i) {
                if (currentOperation.indexOf(patterns[i]) < 0) continue;
                if (i == 0) {
                    return;
                }
                itr.set(currentOperation.replaceAll(patterns[i], replacements[i]));
                if (i != 1) continue;
                return;
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: java -jar Repair.jar [-m <ID*|T>] [-l <FINE|INFO*>] -po <po> -pn <pn>");
            System.out.println("where:");
            System.out.println("<ID|T>: Point to repair, object ids (ID) or insert virtual time at the first column (T).");
            System.out.println("<FINE|INFO>: Logger level.");
            System.out.println("<po>: Path to existing profile, with objects id coming from C++.");
            System.out.println("<pn>: Path where the new profiling report is being created.");
            System.out.println("Example: java -jar Repair.jar -po vdrift.mem -pn vdriftRepaired.mem");
            return;
        }
        String mode = "ID";
        String logLevel = "INFO";
        Level level = null;
        String pathToOriginalProfile = null;
        String pathToNewProfile = null;
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equals("-po")) {
                pathToOriginalProfile = args[i + 1];
                continue;
            }
            if (args[i].equals("-pn")) {
                pathToNewProfile = args[i + 1];
                continue;
            }
            if (args[i].equals("-l")) {
                logLevel = args[i + 1];
                continue;
            }
            if (!args[i].equals("-m")) continue;
            mode = args[i + 1];
        }
        if (logLevel.equals("INFO")) {
            level = Level.INFO;
        } else if (logLevel.equals("FINE")) {
            level = Level.FINE;
        }
        LogManager.getLogManager().getLogger("").setLevel(level);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(level);
            handlers[index].setFormatter(LoggerFormatter.formatter);
        }
        try {
            Repair repair = new Repair(pathToOriginalProfile, pathToNewProfile);
            if (mode.equals("ID")) {
                repair.loadLists();
                repair.fix();
                repair.save();
            } else if (mode.equals("T")) {
                repair.addTime();
            }
        }
        catch (Exception ex) {
            logger.severe(ex.getLocalizedMessage());
        }
    }
}

