/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator;

public class DMMLogger {
    private static double executionTimeReal = 0.0;
    private static double memoryAccessesReal = 0.0;
    private static double memoryUsedInBytesReal = 0.0;
    private static double memoryUsedInHeap = 0.0;
    private static double varAccessesReal = 0.0;
    private static double memUsedByDMMSupport = 0.0;
    private static double memoryUsedByReliableSystem = 0.0;
    private static double memoryAccessedByReliableSystem = 0.0;
    private static double executionTimeReliableSystem = 0.0;

    public static void reset() {
        executionTimeReal = 0.0;
        memoryAccessesReal = 0.0;
        memoryUsedInBytesReal = 0.0;
        memoryUsedInHeap = 0.0;
        varAccessesReal = 0.0;
        memUsedByDMMSupport = 0.0;
    }

    public static void resetReliableSystem() {
        memoryUsedByReliableSystem = 0.0;
        memoryAccessedByReliableSystem = 0.0;
        executionTimeReliableSystem = 0.0;
    }

    public static void addInfinity() {
        executionTimeReal += Double.POSITIVE_INFINITY;
        memoryAccessesReal += Double.POSITIVE_INFINITY;
        memoryUsedInBytesReal += Double.POSITIVE_INFINITY;
        memoryUsedInHeap += Double.POSITIVE_INFINITY;
        varAccessesReal += Double.POSITIVE_INFINITY;
        memUsedByDMMSupport += Double.POSITIVE_INFINITY;
        memoryUsedByReliableSystem += Double.POSITIVE_INFINITY;
        memoryAccessedByReliableSystem += Double.POSITIVE_INFINITY;
        executionTimeReliableSystem += Double.POSITIVE_INFINITY;
    }

    public static void updateData(long incExecutionTime, long incVarAccesses, long incMemoryUsedInBytes, long numMemAccesses) {
        executionTimeReal += (double)incExecutionTime;
        varAccessesReal += (double)incVarAccesses;
        memoryUsedInBytesReal += (double)incMemoryUsedInBytes;
        memoryAccessesReal += (double)numMemAccesses;
    }

    public static void redoDataReal(long incExecutionTime, long incVarAccesses, long incMemoryUsedInBytes, long numMemAccesses) {
        executionTimeReal -= (double)incExecutionTime;
        varAccessesReal -= (double)incVarAccesses;
        memoryUsedInBytesReal -= (double)incMemoryUsedInBytes;
        memoryAccessesReal -= (double)numMemAccesses;
    }

    public static void addMemUsedInHeap(long memUsed) {
        memoryUsedInHeap += (double)memUsed;
    }

    public static void addMemUsedByDMMSupport(long memUsed) {
        memUsedByDMMSupport += (double)memUsed;
    }

    public static void addMemUsedByReliableSystem(long memUsed) {
        memoryUsedByReliableSystem += (double)memUsed;
    }

    public static void addMemoryAccessedByReliableSystem(long accesses) {
        memoryAccessedByReliableSystem += (double)accesses;
    }

    public static void addExecutionTimeReliableSystem(long executionTime) {
        executionTimeReliableSystem += (double)executionTime;
    }

    public static double getExecutionTimeReal() {
        return executionTimeReal;
    }

    public static double getMemoryAccessesReal() {
        return memoryAccessesReal;
    }

    public static double getMemoryUsedInBytesReal() {
        return memoryUsedInBytesReal;
    }

    public static double getMemoryUsedInHeap() {
        return memoryUsedInHeap;
    }

    public static double getVarAccessesReal() {
        return varAccessesReal;
    }

    public static double getMemUsedByDMMSupport() {
        return memUsedByDMMSupport;
    }

    public static double getMemoryUsedByReliableSystem() {
        return memoryUsedByReliableSystem;
    }

    public static double getMemoryAccessedByReliableSystem() {
        return memoryAccessedByReliableSystem;
    }

    public static double getExecutionTimeReliableSystem() {
        return executionTimeReliableSystem;
    }

    public static void printAllInfo() {
        System.out.println("Important info: \n");
        System.out.println("Ex Time (Num Instr)(Real): " + DMMLogger.getExecutionTimeReal());
        System.out.println("Mem Accesses (Real): " + DMMLogger.getMemoryAccessesReal());
        System.out.println("Mem Usage in Bytes (In Heap): " + DMMLogger.getMemoryUsedInHeap());
        System.out.println("Mem Usage in Bytes (In DMM Support): " + DMMLogger.getMemUsedByDMMSupport());
        System.out.println("\nAditional info:\n");
        System.out.println("Variable accesses (Real): " + DMMLogger.getVarAccessesReal());
        System.out.println("Memory Used (Other method to obtain. Not reliable)(Real): " + DMMLogger.getMemoryUsedInBytesReal());
        System.out.println("");
    }

    public static void printRealInfo() {
        System.out.println("Ex Time (Num Instr)(Real): " + DMMLogger.getExecutionTimeReal());
        System.out.println("Mem Accesses (Real): " + DMMLogger.getMemoryAccessesReal());
        System.out.println("Mem Usage in Bytes (In Heap): " + DMMLogger.getMemoryUsedInHeap());
        System.out.println("Mem Usage in Bytes (In DMM Support): " + DMMLogger.getMemUsedByDMMSupport());
        System.out.println("");
    }
}

