/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.combining;

import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.DMMSizesArray;
import jeco.dmm.simulator.layers.AbstractHeap;
import jeco.dmm.simulator.layers.combining.SegHeap2;

public class StrictSegHeap2
extends SegHeap2 {
    public StrictSegHeap2(DMMSizesArray szArray, AbstractHeap littleHeap, AbstractHeap bigHeap) {
        super(szArray, littleHeap, bigHeap);
        DMMLogger.updateData(1L, 4L, 0L, 0L);
    }

    public void freeAll() {
        DMMLogger.updateData(2L, 3L, 0L, 0L);
        for (int i = 0; i < this.numBins; ++i) {
            DMMBlock ptr;
            DMMLogger.updateData(6L, 15L, 0L, 2L);
            long sz = this.cl2sz(i);
            DMMData dataObject = new DMMData(null, sz);
            while ((ptr = this.myLittleHeap[i].malloc(dataObject)) != null) {
                DMMLogger.updateData(2L, 9L, 0L, 4L);
                this.bigHeap.free(ptr.getDataObject());
            }
        }
    }

    public DMMBlock malloc(DMMData dataObject) {
        DMMLogger.updateData(3L, 6L, 0L, 1L);
        DMMBlock ptr = null;
        long sz = dataObject.getSizeInBytes();
        if (sz > this.maxObjectSize) {
            DMMLogger.updateData(1L, 3L, 0L, 1L);
            return this.bigHeap.malloc(dataObject);
        }
        DMMLogger.updateData(4L, 11L, 0L, 2L);
        int sizeClass = this.sz2cl(sz);
        ptr = this.myLittleHeap[sizeClass].malloc(dataObject);
        if (ptr == null && sz != 0L) {
            DMMLogger.updateData(2L, 9L, 0L, 2L);
            dataObject.setSizeInBytes(this.cl2sz(this.sz2cl(sz)));
            ptr = this.bigHeap.malloc(dataObject);
        }
        return ptr;
    }

    public DMMBlock free(DMMData dataObject) {
        DMMLogger.updateData(2L, 5L, 0L, 1L);
        long sz = dataObject.getSizeInBytes();
        if (sz > this.maxObjectSize) {
            DMMLogger.updateData(1L, 3L, 0L, 1L);
            return this.bigHeap.free(dataObject);
        }
        DMMLogger.updateData(2L, 7L, 0L, 2L);
        int objectSizeClass = this.sz2cl(sz);
        return this.myLittleHeap[objectSizeClass].free(dataObject);
    }

    public boolean remove(DMMData dataObject) {
        DMMLogger.updateData(1L, 0L, 0L, 0L);
        return false;
    }
}

