/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.simple;

import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMHeap;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.headers.AbstractHeader;
import jeco.dmm.simulator.headers.LeaHeader;
import jeco.dmm.simulator.layers.AbstractHeap;

public class SlopHeap
extends AbstractHeap {
    protected AbstractHeap child;
    boolean firstTime;

    public SlopHeap(AbstractHeap child, AbstractHeader header) {
        super(header);
        DMMLogger.updateData(3L, 5L, 2L, 0L);
        DMMLogger.addMemUsedByDMMSupport(2L);
        this.child = child;
        this.firstTime = true;
    }

    public DMMBlock free(DMMData dataObject) {
        System.err.println("Error. Free SlopHeap");
        DMMLogger.addInfinity();
        return null;
    }

    public DMMBlock malloc(DMMData dataObject) {
        DMMLogger.updateData(5L, 12L, 0L, 3L);
        DMMBlock block = null;
        long sizeRequested = dataObject.getSizeInBytes();
        long allocSize = sizeRequested + (long)((LeaHeader)this.header).getMaxSizeInBytes();
        long slopSize = ((LeaHeader)this.header).getSlopSize();
        if (this.firstTime) {
            DMMLogger.updateData(3L, 9L, 0L, 2L);
            dataObject.setSizeInBytes(allocSize + slopSize);
            block = this.child.malloc(dataObject);
            if (block == null) {
                DMMLogger.updateData(1L, 1L, 0L, 0L);
                return block;
            }
            DMMLogger.updateData(8L, 22L, 0L, 7L);
            LeaHeader firstHeader = new LeaHeader();
            DMMLogger.redoDataReal(1L, 2L, firstHeader.getMaxSizeInBytes(), 0L);
            DMMData emptyDataObject_1 = new DMMData(null, 0L);
            DMMHeap.newBlock(firstHeader, emptyDataObject_1, 0L);
            LeaHeader secondHeader = new LeaHeader();
            DMMLogger.redoDataReal(1L, 2L, secondHeader.getMaxSizeInBytes(), 0L);
            DMMData emptyDataObject_2 = new DMMData(null, 0L);
            DMMHeap.newBlock(secondHeader, emptyDataObject_2, 0L);
            block.getDataObject().setSizeInBytes(sizeRequested);
            LeaHeader mainHeader = new LeaHeader(sizeRequested, 0L);
            mainHeader.setPrevUsed(false);
            block.setHeader(mainHeader);
            DMMBlock nextBlock = block.getNextInHeap();
            LeaHeader headerNextBlock = (LeaHeader)nextBlock.getHeader();
            headerNextBlock.setPrevDataSize(sizeRequested);
            this.firstTime = false;
        } else {
            DMMLogger.updateData(3L, 8L, 0L, 2L);
            dataObject.setSizeInBytes(allocSize);
            block = this.child.malloc(dataObject);
            if (block == null) {
                DMMLogger.updateData(1L, 1L, 0L, 0L);
                return block;
            }
            DMMLogger.updateData(7L, 29L, 0L, 13L);
            DMMHeap.changeBlocksSlop();
            long originalPrevDataSize = ((LeaHeader)block.getNextInHeap().getHeader()).getPrevDataSize();
            boolean originalIsPrevUsed = ((LeaHeader)block.getNextInHeap().getHeader()).isPrevUsed();
            ((LeaHeader)block.getNextInHeap().getHeader()).setPrevDataSize(sizeRequested);
            LeaHeader mainHeader = new LeaHeader(sizeRequested, originalPrevDataSize);
            mainHeader.setPrevUsed(originalIsPrevUsed);
            block.getDataObject().setSizeInBytes(sizeRequested);
            block.setHeader(mainHeader);
        }
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return block;
    }

    public boolean remove(DMMData dataObject) {
        System.err.println("Error. Remove SlopHeap");
        DMMLogger.addInfinity();
        return false;
    }
}

