/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.test;

import java.io.File;
import jeco.dmm.DMMGrammarFilter;
import jeco.dmm.DMMOptimizer;

public class RubenFixMe {
    protected long memorySizeInKB;
    protected String pathToProfile;
    protected String pathToOutputGrammar;

    public RubenFixMe(long memorySizeInKB, String pathToProfile, String pathToOutputGrammar) throws Exception {
        this.memorySizeInKB = memorySizeInKB;
        this.pathToProfile = pathToProfile;
        this.pathToOutputGrammar = pathToOutputGrammar;
        DMMGrammarFilter filter = new DMMGrammarFilter(memorySizeInKB, pathToProfile, pathToOutputGrammar);
        filter.getInfo();
        filter.createGrammar();
    }

    public void run() throws Exception {
        DMMOptimizer optimizer = new DMMOptimizer(this.memorySizeInKB, this.pathToProfile, this.pathToOutputGrammar);
        optimizer.initialize();
        optimizer.execute();
        System.out.println("Best fitness: " + optimizer.getBestFitness().getDouble());
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            long memory = (long)(16.0 * Math.pow(2.0, 20.0) / Math.pow(2.0, 10.0));
            args = new String[]{String.valueOf(memory), "test" + File.separator + "bigtest.profile", "test" + File.separator + "grammar.bnf"};
        }
        try {
            RubenFixMe test = new RubenFixMe(Long.valueOf(args[0]), args[1], args[2]);
            test.run();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
        }
    }
}

