/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.algorithm.ge;

import Algorithm.MyFirstSearchEngine;
import Algorithm.SimplePipeline;
import FitnessEvaluation.FitnessFunction;
import Individuals.FitnessPackage.Fitness;
import Individuals.Individual;
import Main.ParameterizedState;
import Mapper.GEGrammar;
import Operator.Collector;
import Operator.CrossoverModule;
import Operator.EliteReplacementOperator;
import Operator.FitnessEvaluator;
import Operator.JoinOperator;
import Operator.MutationOperator;
import Operator.Operations.EliteOperationSelection;
import Operator.Operations.EliteReplacementOperation;
import Operator.Operations.FitnessEvaluationOperation;
import Operator.Operations.IntFlipMutation;
import Operator.Operations.ReplacementOperation;
import Operator.Operations.SelectionOperation;
import Operator.Operations.SinglePointCrossover;
import Operator.Operations.StatisticsCollectionOperation;
import Operator.SelectionScheme;
import Util.Random.MersenneTwisterFast;
import Util.Statistics.IndividualCatcher;
import Util.Statistics.StatCatcher;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class GevaToJeco
extends ParameterizedState {
    protected long startTime;

    public GevaToJeco(String pathToGrammarFile, String fitnessFunctionClassName) {
        this.properties = new Properties();
        this.properties.setProperty("mutation_probability", "0.02");
        this.properties.setProperty("initialiser", "Operator.RampedFullGrowInitialiser");
        this.properties.setProperty("grow_probability", "0.5");
        this.properties.setProperty("max_depth", "4");
        this.properties.setProperty("generations", "100");
        this.properties.setProperty("replacement_type", "generational");
        this.properties.setProperty("generation_gap", "0.5");
        this.properties.setProperty("fixed_point_crossover", "false");
        this.properties.setProperty("evaluate_elites", "false");
        this.properties.setProperty("userpick_size", "20");
        this.properties.setProperty("grammar_file", pathToGrammarFile);
        this.properties.setProperty("population_size", "100");
        this.properties.setProperty("output", "");
        this.properties.setProperty("fitness_function", fitnessFunctionClassName);
        this.properties.setProperty("max_wraps", "3");
        this.properties.setProperty("selection_operation", "Operator.Operations.TournamentSelect");
        this.properties.setProperty("crossover_probability", "0.7");
        this.properties.setProperty("elite_size", "10");
        this.properties.setProperty("tournament_size", "3");
        this.properties.setProperty("stopWhenSolved", "false");
        this.rng = new MersenneTwisterFast();
        this.startTime = System.currentTimeMillis();
    }

    public void setup(String[] args) {
        this.setSeed();
        GEGrammar grammar = new GEGrammar(this.properties);
        MyFirstSearchEngine alg = new MyFirstSearchEngine();
        this.initialiser = this.getInitialiser(grammar, this.rng, this.properties);
        SinglePointCrossover singlePointCrossover = new SinglePointCrossover(this.rng, this.properties);
        CrossoverModule crossoverModule = new CrossoverModule(this.rng, singlePointCrossover);
        IntFlipMutation mutation = new IntFlipMutation(this.rng, this.properties);
        MutationOperator mutationModule = new MutationOperator(this.rng, mutation);
        SelectionOperation selectionOperation = this.getSelectionOperation(this.properties, this.rng);
        SelectionScheme selectionScheme = new SelectionScheme(this.rng, selectionOperation);
        ReplacementOperation replacementOperation = new ReplacementOperation(this.properties);
        JoinOperator replacementStrategy = this.getJoinOperator(this.properties, this.rng, selectionScheme.getPopulation(), replacementOperation);
        EliteOperationSelection eliteSelectionOperation = new EliteOperationSelection(this.properties);
        SelectionScheme eliteSelection = new SelectionScheme(this.rng, eliteSelectionOperation);
        EliteReplacementOperation eliteReplacementOperation = new EliteReplacementOperation(this.properties);
        EliteReplacementOperator eliteReplacementStrategy = new EliteReplacementOperator(this.rng, eliteSelection.getPopulation(), eliteReplacementOperation);
        FitnessFunction fitnessFunction = this.getFitnessFunction(this.properties);
        FitnessEvaluationOperation fitnessEvaluationOperation = new FitnessEvaluationOperation(fitnessFunction);
        fitnessEvaluationOperation.setProperties(this.properties);
        FitnessEvaluator fitnessEvaluator = new FitnessEvaluator(this.rng, fitnessEvaluationOperation);
        StatCatcher stats = new StatCatcher(Integer.parseInt(this.properties.getProperty("generations")));
        IndividualCatcher indCatch = new IndividualCatcher(this.properties);
        stats.addTime(this.startTime);
        StatisticsCollectionOperation statsCollection = new StatisticsCollectionOperation(stats, indCatch, this.properties);
        Collector collector = new Collector(statsCollection);
        SimplePipeline pipelineInit = new SimplePipeline();
        alg.setInitPipeline(pipelineInit);
        FitnessEvaluator fitnessEvaluatorInit = new FitnessEvaluator(this.rng, fitnessEvaluationOperation);
        fitnessEvaluatorInit.setPopulation(this.initialiser.getPopulation());
        collector.setPopulation(this.initialiser.getPopulation());
        pipelineInit.addModule(this.initialiser);
        pipelineInit.addModule(fitnessEvaluatorInit);
        pipelineInit.addModule(collector);
        SimplePipeline pipelineLoop = new SimplePipeline();
        alg.setLoopPipeline(pipelineLoop);
        selectionScheme.setPopulation(this.initialiser.getPopulation());
        replacementStrategy.setPopulation(this.initialiser.getPopulation());
        crossoverModule.setPopulation(selectionScheme.getPopulation());
        mutationModule.setPopulation(selectionScheme.getPopulation());
        fitnessEvaluator.setPopulation(selectionScheme.getPopulation());
        eliteSelection.setPopulation(this.initialiser.getPopulation());
        eliteReplacementStrategy.setPopulation(this.initialiser.getPopulation());
        collector.setPopulation(this.initialiser.getPopulation());
        pipelineLoop.addModule(eliteSelection);
        pipelineLoop.addModule(selectionScheme);
        pipelineLoop.addModule(crossoverModule);
        pipelineLoop.addModule(mutationModule);
        pipelineLoop.addModule(fitnessEvaluator);
        pipelineLoop.addModule(replacementStrategy);
        pipelineLoop.addModule(eliteReplacementStrategy);
        pipelineLoop.addModule(collector);
        this.algorithm = alg;
    }

    private void setSeed() {
        if (this.properties.getProperty("rng_seed") != null) {
            long seed = Long.parseLong(this.properties.getProperty("rng_seed"));
            this.rng.setSeed(seed);
        }
    }

    public Fitness getBestFitness() {
        List<Individual> population = this.initialiser.getPopulation().getAll();
        Object[] fitnessArray = new Fitness[population.size()];
        for (int i = 0; i < fitnessArray.length; ++i) {
            fitnessArray[i] = population.get(i).getFitness();
        }
        Arrays.sort(fitnessArray);
        return fitnessArray[0];
    }

    public void step() {
        this.algorithm.step();
    }

    public void execute() {
        int numberOfIterations = super.run();
    }

    public void initialize() {
        this.setup(null);
        super.init();
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }
}

