/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.crossover;

import java.util.ArrayList;
import jeco.kernel.operator.crossover.CrossoverOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Variable;

public class CycleCrossover
extends CrossoverOperator {
    public static final double DEFAULT_PROBABILITY = 0.9;
    protected double probability;

    public CycleCrossover() {
        this.probability = 0.9;
    }

    public CycleCrossover(double probability) {
        this.probability = probability;
    }

    private Integer lookForPosition(Solution parent, Variable variable) {
        if (variable == null) {
            return 0;
        }
        Variable varJ = null;
        for (int j = 0; j < parent.getVariables().length; ++j) {
            varJ = parent.getVariable(j);
            if (!variable.equals(varJ)) continue;
            return j;
        }
        return -1;
    }

    public Solution[] doCrossover(double probability, Solution parent1, Solution parent2) {
        Solution[] offSpring = new Solution[]{parent1.clone(), parent2.clone()};
        Integer currentPos = 0;
        ArrayList<Integer> cycle = new ArrayList<Integer>();
        cycle.add(currentPos);
        Variable variable = parent2.getVariable(currentPos);
        currentPos = this.lookForPosition(parent1, variable);
        while (currentPos != 0) {
            cycle.add(currentPos);
            variable = parent2.getVariable(currentPos);
            currentPos = this.lookForPosition(parent1, variable);
        }
        for (int i = 0; i < parent1.getVariables().length; ++i) {
            if (cycle.contains(i)) {
                offSpring[0].setVariable(i, parent1.getVariable(i).clone());
                offSpring[1].setVariable(i, parent2.getVariable(i).clone());
                continue;
            }
            offSpring[0].setVariable(i, parent2.getVariable(i).clone());
            offSpring[1].setVariable(i, parent1.getVariable(i).clone());
        }
        return offSpring;
    }

    public Solution[] execute(Solution parent1, Solution parent2) {
        return this.doCrossover(this.probability, parent1, parent2);
    }
}

