/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.operator.selector.SelectionOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.util.RandomGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TournamentSelect
extends SelectionOperator {
    public static final int DEFAULT_TOURNAMENT_SIZE = 2;
    protected Comparator<Solution> comparator;
    protected int tournamentSize;

    public TournamentSelect(int tournamentSize, Comparator<Solution> comparator) {
        this.tournamentSize = tournamentSize;
        this.comparator = comparator;
    }

    public TournamentSelect(Comparator<Solution> comparator) {
        this(2, comparator);
    }

    public TournamentSelect() {
        this(2, new SolutionDominance());
    }

    @Override
    public Solution execute(Solutions solutions) {
        ArrayList tournamentSet = new ArrayList();
        for (int i = 0; i < this.tournamentSize; ++i) {
            tournamentSet.add(solutions.get(RandomGenerator.nextInteger(solutions.size())));
        }
        Collections.sort(tournamentSet, this.comparator);
        return (Solution)tournamentSet.get(0);
    }
}

